/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;

public class FieldAnnotationValueChangeCommand
extends AbstractDataModelCommand {
    protected ObjectProperty field;

    public FieldAnnotationValueChangeCommand(DataModelerContext context, String source, DataObject dataObject, ObjectProperty field, String annotationClassName, String valuePair, Object newValue, boolean removeIfNull, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, annotationClassName, valuePair, newValue, removeIfNull, notifier);
        this.field = field;
    }

    public ObjectProperty getField() {
        return this.field;
    }

    public void setField(ObjectProperty field) {
        this.field = field;
    }

    @Override
    public void execute() {
        Object oldValue = null;
        Annotation annotation = this.field.getAnnotation(this.annotationClassName);
        if (annotation != null) {
            oldValue = annotation.getValue(this.valuePair);
            if (this.newValue != null && !this.newValue.equals(oldValue)) {
                annotation.setValue(this.valuePair, this.newValue);
                this.notifyFieldChange(ChangeType.FIELD_ANNOTATION_VALUE_CHANGE, this.context, this.source, this.dataObject, this.field, this.annotationClassName, this.valuePair, oldValue, this.newValue);
            } else if (this.newValue == null) {
                if (this.removeAnnotationIfValueIsNull) {
                    this.field.removeAnnotation(this.annotationClassName);
                    this.notifyFieldChange(ChangeType.FIELD_ANNOTATION_REMOVE_CHANGE, this.context, this.source, this.dataObject, this.field, this.annotationClassName, this.valuePair, oldValue, this.newValue);
                } else {
                    annotation.removeValue(this.valuePair);
                    this.notifyFieldChange(ChangeType.FIELD_ANNOTATION_VALUE_CHANGE, this.context, this.source, this.dataObject, this.field, this.annotationClassName, this.valuePair, oldValue, this.newValue);
                }
            }
        } else if (this.newValue != null) {
            annotation = new AnnotationImpl(this.context.getAnnotationDefinitions().get(this.annotationClassName));
            annotation.setValue(this.valuePair, this.newValue);
            this.field.addAnnotation(annotation);
            this.notifyFieldChange(ChangeType.FIELD_ANNOTATION_ADD_CHANGE, this.context, this.source, this.dataObject, this.field, this.annotationClassName, this.valuePair, oldValue, this.newValue);
        }
    }
}

