/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.handlers;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandler;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ResourceOptions;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.screens.javaeditor.client.resources.JavaEditorResources;
import org.kie.workbench.common.screens.javaeditor.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.javaeditor.client.type.JavaResourceType;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewJavaFileTextHandler
extends DefaultNewResourceHandler {
    @Inject
    private Caller<DataModelerService> dataModelerService;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private JavaResourceType resourceType;
    @Inject
    private BusyIndicatorView busyIndicatorView;
    @Inject
    private SyncBeanManager iocBeanManager;
    private List<ResourceOptions> resourceOptions = new ArrayList<ResourceOptions>();
    @Inject
    private DomainHandlerRegistry domainHandlerRegistry;

    @PostConstruct
    private void setupExtensions() {
        for (DomainHandler handler : this.domainHandlerRegistry.getDomainHandlers()) {
            ResourceOptions options = handler.getResourceOptions(false);
            if (options == null) continue;
            this.resourceOptions.add(options);
            this.extensions.add(new Pair((Object)handler.getName(), (Object)options.getWidget()));
        }
    }

    public String getDescription() {
        return Constants.INSTANCE.newJavaFile();
    }

    public IsWidget getIcon() {
        return new Image(JavaEditorResources.INSTANCE.images().typeJava());
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    public void create(Package pkg, String baseFileName, NewResourcePresenter presenter) {
        this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Saving());
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (ResourceOptions options : this.resourceOptions) {
            params.putAll(options.getOptions());
        }
        ((DataModelerService)this.dataModelerService.call(this.getSuccessCallback(presenter), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).createJavaFile(pkg.getPackageMainSrcPath(), this.buildFileName(baseFileName, (ResourceTypeDefinition)this.resourceType), "", params);
    }

    public void validate(final String javaFileName, final ValidatorWithReasonCallback callback) {
        ((ValidationService)this.validationService.call((RemoteCallback)new RemoteCallback<Boolean>(){

            public void callback(Boolean response) {
                if (Boolean.TRUE.equals(response)) {
                    callback.onSuccess();
                } else {
                    callback.onFailure(CommonConstants.INSTANCE.InvalidFileName0(javaFileName));
                }
            }
        })).isJavaFileNameValid(javaFileName + ".java");
    }

    public Command getCommand(NewResourcePresenter newResourcePresenter) {
        for (ResourceOptions options : this.resourceOptions) {
            options.restoreOptionsDefaults();
        }
        return super.getCommand(newResourcePresenter);
    }

    public boolean supportsDefaultPackage() {
        return false;
    }

    public int order() {
        return -10;
    }
}

