/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kie.workbench.common.screens.datamodeller.client.util.AnnotationValueHandler;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.CascadeType;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.FetchMode;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.RelationType;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;

public class RelationshipAnnotationValueHandler
extends AnnotationValueHandler {
    public static final String RELATION_TYPE = "relationType";
    public static final String CASCADE = "cascade";
    public static final String FETCH = "fetch";
    public static final String OPTIONAL = "optional";
    public static final String MAPPED_BY = "mappedBy";
    public static final String ORPHAN_REMOVAL = "orphanRemoval";

    public RelationshipAnnotationValueHandler(Annotation annotation) {
        super(annotation);
    }

    public RelationType getRelationType() {
        if ("javax.persistence.OneToOne".equals(this.annotation.getClassName())) {
            return RelationType.ONE_TO_ONE;
        }
        if ("javax.persistence.OneToMany".equals(this.annotation.getClassName())) {
            return RelationType.ONE_TO_MANY;
        }
        if ("javax.persistence.ManyToOne".equals(this.annotation.getClassName())) {
            return RelationType.MANY_TO_ONE;
        }
        if ("javax.persistence.ManyToMany".equals(this.annotation.getClassName())) {
            return RelationType.MANY_TO_MANY;
        }
        return null;
    }

    public boolean isOneToOne() {
        return RelationType.ONE_TO_ONE.equals((Object)this.getRelationType());
    }

    public boolean isOneToMany() {
        return RelationType.ONE_TO_MANY.equals((Object)this.getRelationType());
    }

    public boolean isManyToOne() {
        return RelationType.MANY_TO_ONE.equals((Object)this.getRelationType());
    }

    public boolean isManyToMany() {
        return RelationType.MANY_TO_MANY.equals((Object)this.getRelationType());
    }

    public List<CascadeType> getCascade() {
        ArrayList<CascadeType> cascadeTypes;
        List internalCascadeTypes = (List)this.annotation.getValue(CASCADE);
        ArrayList<CascadeType> arrayList = cascadeTypes = internalCascadeTypes != null ? new ArrayList<CascadeType>(internalCascadeTypes.size()) : null;
        if (internalCascadeTypes != null) {
            for (Object internalCascadeType : internalCascadeTypes) {
                try {
                    cascadeTypes.add(internalCascadeType != null ? CascadeType.valueOf((String)internalCascadeType.toString()) : null);
                }
                catch (Exception exception) {}
            }
        }
        return cascadeTypes;
    }

    public void setCascade(List<CascadeType> cascade) {
        if (cascade != null) {
            ArrayList<String> cascadeTypes = new ArrayList<String>(cascade.size());
            for (CascadeType cascadeType : cascade) {
                cascadeTypes.add(cascadeType.name());
            }
            this.annotation.setValue(CASCADE, cascadeTypes);
        } else {
            this.annotation.removeValue(CASCADE);
        }
    }

    public FetchMode getFetch() {
        try {
            return FetchMode.valueOf((String)RelationshipAnnotationValueHandler.getStringValue(this.annotation, FETCH));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setFetch(FetchMode fetch) {
        if (fetch != null) {
            this.annotation.setValue(FETCH, (Object)fetch.name());
        } else {
            this.annotation.removeValue(FETCH);
        }
    }

    public Boolean getOptional() {
        String value = RelationshipAnnotationValueHandler.getStringValue(this.annotation, OPTIONAL);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    public void setOptional(Boolean optional) {
        if (optional != null) {
            this.annotation.setValue(OPTIONAL, (Object)optional.toString());
        } else {
            this.annotation.removeValue(OPTIONAL);
        }
    }

    public String getMappedBy() {
        return RelationshipAnnotationValueHandler.getStringValue(this.annotation, MAPPED_BY);
    }

    public void setMappedBy(String mappedBy) {
        if (mappedBy != null) {
            this.annotation.setValue(MAPPED_BY, (Object)mappedBy);
        } else {
            this.annotation.removeValue(MAPPED_BY);
        }
    }

    public Boolean getOrphanRemoval() {
        String value = RelationshipAnnotationValueHandler.getStringValue(this.annotation, ORPHAN_REMOVAL);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    public void setOrphanRemoval(Boolean orphanRemoval) {
        if (orphanRemoval != null) {
            this.annotation.setValue(ORPHAN_REMOVAL, (Object)orphanRemoval.toString());
        } else {
            this.annotation.removeValue(ORPHAN_REMOVAL);
        }
    }

    public static Annotation createAnnotation(RelationType relationType, List<CascadeType> cascadeTypes, Map<String, AnnotationDefinition> annotationDefinitions) {
        return RelationshipAnnotationValueHandler.createAnnotation(relationType, cascadeTypes, null, null, null, null, annotationDefinitions);
    }

    public static Annotation createAnnotation(RelationType relationType, List<CascadeType> cascadeTypes, FetchMode fetchMode, Boolean optional, String mappedBy, Boolean orphanRemoval, Map<String, AnnotationDefinition> annotationDefinitions) {
        if (relationType == null) {
            return null;
        }
        RelationshipAnnotationValueHandler valueHandler = null;
        switch (relationType) {
            case ONE_TO_ONE: {
                valueHandler = new RelationshipAnnotationValueHandler((Annotation)new AnnotationImpl(annotationDefinitions.get("javax.persistence.OneToOne")));
                valueHandler.setOptional(optional);
                valueHandler.setMappedBy(mappedBy);
                valueHandler.setOrphanRemoval(orphanRemoval);
                break;
            }
            case ONE_TO_MANY: {
                valueHandler = new RelationshipAnnotationValueHandler((Annotation)new AnnotationImpl(annotationDefinitions.get("javax.persistence.OneToMany")));
                valueHandler.setMappedBy(mappedBy);
                valueHandler.setOrphanRemoval(orphanRemoval);
                break;
            }
            case MANY_TO_ONE: {
                valueHandler = new RelationshipAnnotationValueHandler((Annotation)new AnnotationImpl(annotationDefinitions.get("javax.persistence.ManyToOne")));
                valueHandler.setOptional(optional);
                break;
            }
            case MANY_TO_MANY: {
                valueHandler = new RelationshipAnnotationValueHandler((Annotation)new AnnotationImpl(annotationDefinitions.get("javax.persistence.ManyToMany")));
                valueHandler.setMappedBy(mappedBy);
            }
        }
        valueHandler.setFetch(fetchMode);
        valueHandler.setCascade(cascadeTypes);
        return valueHandler.getAnnotation();
    }
}

