/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.pdescriptor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.PersistenceUnitPropertyGridView;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.PropertyRow;
import org.kie.workbench.common.screens.datamodeller.client.pdescriptor.PropertyRowImpl;

@Dependent
public class PersistenceUnitPropertyGrid
implements IsWidget,
PersistenceUnitPropertyGridView.Presenter {
    private PersistenceUnitPropertyGridView view;
    private List<PropertyRow> properties;
    private ListDataProvider<PropertyRow> dataProvider = new ListDataProvider();

    public PersistenceUnitPropertyGrid() {
    }

    @Inject
    public PersistenceUnitPropertyGrid(PersistenceUnitPropertyGridView view) {
        this.view = view;
        view.setPresenter(this);
        view.setDataProvider(this.dataProvider);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setProperties(List<PropertyRow> properties) {
        this.properties = properties;
        this.dataProvider.getList().clear();
        if (properties != null) {
            this.dataProvider.getList().addAll(properties);
        }
    }

    public List<PropertyRow> getProperties() {
        return this.properties;
    }

    @Override
    public void onAddProperty() {
        String propertyName = this.view.getNewPropertyName();
        String propertyValue = this.view.getNewPropertyValue();
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyRow>();
        }
        this.properties.add(new PropertyRowImpl(propertyName, propertyValue));
        this.setProperties(this.properties);
        this.view.setNewPropertyName("");
        this.view.setNewPropertyValue("");
    }

    @Override
    public void onRemoveProperty(PropertyRow propertyRow) {
        if (this.properties != null) {
            this.properties.remove(propertyRow);
        }
        this.setProperties(this.properties);
    }

    public void setReadOnly(boolean readOnly) {
        this.view.setReadOnly(readOnly);
    }

    public void redraw() {
        this.view.redraw();
    }
}

