/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.util;

import java.util.Comparator;
import org.kie.workbench.common.screens.datamodeller.client.util.AnnotationValueHandler;
import org.kie.workbench.common.services.datamodeller.core.HasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;

public class ObjectPropertyComparator
implements Comparator<ObjectProperty> {
    private String field;
    private boolean ascending = true;

    public ObjectPropertyComparator(String field) {
        this.field = field;
        this.ascending = true;
    }

    public ObjectPropertyComparator(String field, boolean ascending) {
        this.field = field;
        this.ascending = ascending;
    }

    @Override
    public int compare(ObjectProperty o1, ObjectProperty o2) {
        return this.ascending ? this._compare(o1, o2) : -this._compare(o1, o2);
    }

    private int _compare(ObjectProperty o1, ObjectProperty o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return -1;
        }
        if (o1 != null && o2 == null) {
            return 1;
        }
        Object key1 = null;
        Object key2 = null;
        if ("className".equals(this.field)) {
            key1 = o1.getClassName();
            key2 = o2.getClassName();
        } else if ("name".equals(this.field)) {
            key1 = o1.getName();
            key2 = o2.getName();
        } else if ("label".equals(this.field)) {
            key1 = AnnotationValueHandler.getStringValue((HasAnnotations)o1, "org.kie.api.definition.type.Label", "value");
            key2 = AnnotationValueHandler.getStringValue((HasAnnotations)o2, "org.kie.api.definition.type.Label", "value");
        } else if ("position".equals(this.field)) {
            key1 = AnnotationValueHandler.getStringValue((HasAnnotations)o1, "org.kie.api.definition.type.Position", "value");
            key2 = AnnotationValueHandler.getStringValue((HasAnnotations)o2, "org.kie.api.definition.type.Position", "value");
            if (key1 != null) {
                try {
                    key1 = new Integer(key1.toString());
                }
                catch (NumberFormatException e) {
                    key1 = null;
                }
            }
            if (key2 != null) {
                try {
                    key2 = new Integer(key2.toString());
                }
                catch (NumberFormatException e) {
                    key2 = null;
                }
            }
        }
        if (key1 == null && key2 == null) {
            return 0;
        }
        if (key1 != null && key2 != null) {
            return key1.compareTo(key2);
        }
        if (key1 == null && key2 != null) {
            return -1;
        }
        return 1;
    }
}

