/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor.item;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor.AdvancedAnnotationListEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor.item.AnnotationListItemView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor.item.AnnotationValuePairListItem;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSource;

@Dependent
public class AnnotationListItem
implements AnnotationListItemView.Presenter,
IsWidget {
    private AnnotationListItemView view;
    private Annotation annotation;
    private AdvancedAnnotationListEditorView.DeleteAnnotationHandler deleteAnnotationHandler;
    private AdvancedAnnotationListEditorView.ClearValuePairHandler clearValuePairHandler;
    private AdvancedAnnotationListEditorView.EditValuePairHandler editValuePairHandler;
    private AdvancedAnnotationListEditorView.CollapseChangeHandler collapseChangeHandler;
    private List<AnnotationValuePairListItem> items = new ArrayList<AnnotationValuePairListItem>();
    private Instance<AnnotationValuePairListItem> itemInstance;

    public AnnotationListItem() {
    }

    @Inject
    public AnnotationListItem(AnnotationListItemView view, Instance<AnnotationValuePairListItem> itemInstance) {
        this.view = view;
        view.init(this);
        this.itemInstance = itemInstance;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void loadAnnotation(Annotation annotation, AnnotationSource annotationSource) {
        this.annotation = annotation;
        this.view.setHeadingTitle(annotation.getClassName());
        if (annotation.getAnnotationDefinition() != null && annotation.getAnnotationDefinition().getValuePairs() != null) {
            for (AnnotationValuePairDefinition valuePairDefinition : annotation.getAnnotationDefinition().getValuePairs()) {
                AnnotationValuePairListItem valuePairListItem = this.createListItem();
                valuePairListItem.loadValuePair(annotation, valuePairDefinition, annotationSource);
                valuePairListItem.setClearValuePairHandler(new AdvancedAnnotationListEditorView.ClearValuePairHandler(){

                    @Override
                    public void onClearValuePair(Annotation annotation, String valuePair) {
                        if (AnnotationListItem.this.clearValuePairHandler != null) {
                            AnnotationListItem.this.clearValuePairHandler.onClearValuePair(annotation, valuePair);
                        }
                    }
                });
                valuePairListItem.setEditValuePairHandler(new AdvancedAnnotationListEditorView.EditValuePairHandler(){

                    @Override
                    public void onEditValuePair(Annotation annotation, String valuePair) {
                        if (AnnotationListItem.this.editValuePairHandler != null) {
                            AnnotationListItem.this.editValuePairHandler.onEditValuePair(annotation, valuePair);
                        }
                    }
                });
                this.view.addItem(valuePairListItem);
                this.items.add(valuePairListItem);
            }
        }
    }

    public void setDeleteAnnotationHandler(AdvancedAnnotationListEditorView.DeleteAnnotationHandler deleteAnnotationHandler) {
        this.deleteAnnotationHandler = deleteAnnotationHandler;
    }

    public void setClearValuePairHandler(AdvancedAnnotationListEditorView.ClearValuePairHandler clearValuePairHandler) {
        this.clearValuePairHandler = clearValuePairHandler;
    }

    public void setEditValuePairHandler(AdvancedAnnotationListEditorView.EditValuePairHandler editValuePairHandler) {
        this.editValuePairHandler = editValuePairHandler;
    }

    public void setCollapseChangeHandler(AdvancedAnnotationListEditorView.CollapseChangeHandler collapseChangeHandler) {
        this.collapseChangeHandler = collapseChangeHandler;
    }

    public boolean isCollapsed() {
        return this.view.isCollapsed();
    }

    public void setCollapsed(boolean collapsed) {
        this.view.setCollapsed(collapsed);
    }

    public void setReadonly(boolean readonly) {
        this.view.setReadonly(readonly);
        for (AnnotationValuePairListItem item : this.items) {
            item.setReadonly(readonly);
        }
    }

    @Override
    public void onDelete() {
        if (this.deleteAnnotationHandler != null) {
            this.deleteAnnotationHandler.onDeleteAnnotation(this.annotation);
        }
    }

    @Override
    public void onCollapseChange() {
        if (this.collapseChangeHandler != null) {
            this.collapseChangeHandler.onCollapseChange();
        }
    }

    @PreDestroy
    protected void destroy() {
        for (AnnotationValuePairListItem item : this.items) {
            this.dispose(item);
        }
        this.items.clear();
    }

    protected AnnotationValuePairListItem createListItem() {
        return (AnnotationValuePairListItem)this.itemInstance.get();
    }

    protected void dispose(AnnotationValuePairListItem listItem) {
        this.itemInstance.destroy((Object)listItem);
    }
}

