/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor.item;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor.AdvancedAnnotationListEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor.item.AnnotationValuePairListItemView;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSource;

@Dependent
public class AnnotationValuePairListItem
implements AnnotationValuePairListItemView.Presenter,
IsWidget {
    private AnnotationValuePairListItemView view;
    private AdvancedAnnotationListEditorView.ClearValuePairHandler clearValuePairHandler;
    private AdvancedAnnotationListEditorView.EditValuePairHandler editValuePairHandler;
    private Annotation annotation;
    private AnnotationValuePairDefinition valuePairDefinition;

    public AnnotationValuePairListItem() {
    }

    @Inject
    public AnnotationValuePairListItem(AnnotationValuePairListItemView view) {
        this.view = view;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void loadValuePair(Annotation annotation, AnnotationValuePairDefinition valuePairDefinition, AnnotationSource annotationSource) {
        this.annotation = annotation;
        this.valuePairDefinition = valuePairDefinition;
        this.view.setValuePairName(valuePairDefinition.getName());
        this.view.setValuePairStringValue(this.getValuePairStringValue(annotation, valuePairDefinition, annotationSource));
        if (valuePairDefinition.getDefaultValue() == null) {
            this.view.showRequiredIndicator(true);
        }
    }

    public void setReadonly(boolean readonly) {
        this.view.setReadonly(readonly);
    }

    public void setClearValuePairHandler(AdvancedAnnotationListEditorView.ClearValuePairHandler clearValuePairHandler) {
        this.clearValuePairHandler = clearValuePairHandler;
    }

    public void setEditValuePairHandler(AdvancedAnnotationListEditorView.EditValuePairHandler editValuePairHandler) {
        this.editValuePairHandler = editValuePairHandler;
    }

    @Override
    public void onEdit() {
        if (this.editValuePairHandler != null) {
            this.editValuePairHandler.onEditValuePair(this.annotation, this.valuePairDefinition.getName());
        }
    }

    @Override
    public void onClear() {
        if (this.clearValuePairHandler != null) {
            this.clearValuePairHandler.onClearValuePair(this.annotation, this.valuePairDefinition.getName());
        }
    }

    private String getValuePairStringValue(Annotation annotation, AnnotationValuePairDefinition valuePairDefinition, AnnotationSource annotationSource) {
        String strValue;
        Object value = annotation.getValue(valuePairDefinition.getName());
        if (value == null) {
            strValue = Constants.INSTANCE.advanced_domain_annotation_list_editor_message_value_not_set();
        } else {
            String string = strValue = annotationSource != null ? annotationSource.getValuePairSource(valuePairDefinition.getName()) : null;
            if (strValue == null) {
                strValue = Constants.INSTANCE.advanced_domain_annotation_list_editor_message_source_code_not_available();
            }
        }
        return strValue;
    }
}

