/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationwizard;

import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationwizard.CreateAnnotationWizard;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationwizard.CreateAnnotationWizardPage;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationwizard.ValuePairEditorPageView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.ValuePairEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.ValuePairEditorProvider;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.generic.GenericValuePairEditor;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.core.ElementType;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationParseRequest;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationParseResponse;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class ValuePairEditorPage
extends CreateAnnotationWizardPage
implements ValuePairEditorPageView.Presenter {
    private ValuePairEditorPageView view;
    private ValuePairEditorProvider valuePairEditorProvider;
    private AnnotationValuePairDefinition valuePairDefinition;
    private Object currentValue = null;

    @Inject
    public ValuePairEditorPage(ValuePairEditorPageView view, ValuePairEditorProvider valuePairEditorProvider, Caller<DataModelerService> modelerService, Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent) {
        super(modelerService, wizardPageStatusChangeEvent);
        this.valuePairEditorProvider = valuePairEditorProvider;
        this.view = view;
        view.init(this);
        this.setTitle("");
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void init(AnnotationDefinition annotationDefinition, AnnotationValuePairDefinition valuePairDefinition, ElementType target, KieModule project) {
        this.annotationDefinition = annotationDefinition;
        this.setValuePairDefinition(valuePairDefinition);
        this.target = target;
        this.project = project;
        this.setStatus(this.isRequired() ? CreateAnnotationWizardPage.PageStatus.NOT_VALIDATED : CreateAnnotationWizardPage.PageStatus.VALIDATED);
    }

    public String getStringValue() {
        return this.view.getStringValue();
    }

    public AnnotationValuePairDefinition getValuePairDefinition() {
        return this.valuePairDefinition;
    }

    public Object getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public void onValidate() {
        ((DataModelerService)this.modelerService.call(this.getOnValidateValidateSuccessCallback(), (ErrorCallback)new CreateAnnotationWizard.CreateAnnotationWizardErrorCallback())).resolveParseRequest(new AnnotationParseRequest(this.annotationDefinition.getClassName(), this.target, this.valuePairDefinition.getName(), this.getStringValue()), this.project);
    }

    @Override
    public void onValueChange() {
        CreateAnnotationWizardPage.PageStatus nextStatus = CreateAnnotationWizardPage.PageStatus.NOT_VALIDATED;
        this.currentValue = this.view.getValuePairEditor().getValue();
        if (this.view.getValuePairEditor() instanceof GenericValuePairEditor) {
            if (this.isRequired()) {
                if (this.isEmpty(this.currentValue)) {
                    this.setHelpMessage(Constants.INSTANCE.advanced_domain_wizard_value_pair_editor_page_message_enter_required_value_and_validate());
                } else {
                    this.setHelpMessage(Constants.INSTANCE.advanced_domain_wizard_value_pair_editor_page_message_value_not_validated());
                }
                nextStatus = CreateAnnotationWizardPage.PageStatus.NOT_VALIDATED;
            } else if (this.isEmpty(this.currentValue)) {
                this.setHelpMessage(Constants.INSTANCE.advanced_domain_wizard_value_pair_editor_page_message_enter_optional_value_and_validate());
                nextStatus = CreateAnnotationWizardPage.PageStatus.VALIDATED;
            } else {
                this.setHelpMessage(Constants.INSTANCE.advanced_domain_wizard_value_pair_editor_page_message_value_not_validated());
                nextStatus = CreateAnnotationWizardPage.PageStatus.NOT_VALIDATED;
            }
        } else if (this.view.getValuePairEditor().isValid() && (this.isRequired() && this.view.getValuePairEditor().getValue() != null || !this.isRequired())) {
            nextStatus = CreateAnnotationWizardPage.PageStatus.VALIDATED;
        }
        this.setStatus(nextStatus);
    }

    private void setValuePairDefinition(AnnotationValuePairDefinition valuePairDefinition) {
        this.valuePairDefinition = valuePairDefinition;
        String required = this.isRequired() ? "* " : "";
        this.setTitle("  -> " + required + valuePairDefinition.getName());
        this.initValuePairEditor(valuePairDefinition);
        if (this.view.getValuePairEditor() instanceof GenericValuePairEditor) {
            if (this.isRequired()) {
                this.setHelpMessage(Constants.INSTANCE.advanced_domain_wizard_value_pair_editor_page_message_enter_required_value_and_validate());
            } else {
                this.setHelpMessage(Constants.INSTANCE.advanced_domain_wizard_value_pair_editor_page_message_enter_optional_value_and_validate());
            }
        }
    }

    private void initValuePairEditor(AnnotationValuePairDefinition valuePairDefinition) {
        ValuePairEditor valuePairEditor = this.valuePairEditorProvider.getValuePairEditor(valuePairDefinition);
        this.view.setValuePairEditor(valuePairEditor);
    }

    private RemoteCallback<AnnotationParseResponse> getOnValidateValidateSuccessCallback() {
        return new RemoteCallback<AnnotationParseResponse>(){

            public void callback(AnnotationParseResponse annotationParseResponse) {
                CreateAnnotationWizardPage.PageStatus newStatus;
                if (!annotationParseResponse.hasErrors() && annotationParseResponse.getAnnotation() != null) {
                    ValuePairEditorPage.this.currentValue = annotationParseResponse.getAnnotation().getValue(ValuePairEditorPage.this.valuePairDefinition.getName());
                    newStatus = CreateAnnotationWizardPage.PageStatus.VALIDATED;
                    ValuePairEditorPage.this.setHelpMessage(Constants.INSTANCE.advanced_domain_wizard_value_pair_editor_page_message_value_validated());
                } else {
                    ValuePairEditorPage.this.currentValue = null;
                    newStatus = CreateAnnotationWizardPage.PageStatus.NOT_VALIDATED;
                    String errorMessage = Constants.INSTANCE.advanced_domain_wizard_value_pair_editor_page_message_value_not_validated();
                    errorMessage = errorMessage + "\n" + ValuePairEditorPage.this.buildErrorList(annotationParseResponse.getErrors());
                    ValuePairEditorPage.this.setHelpMessage(errorMessage);
                }
                ValuePairEditorPage.this.setStatus(newStatus);
            }
        };
    }

    private void clearHelpMessage() {
        this.view.clearHelpMessage();
    }

    private void setHelpMessage(String helpMessage) {
        this.view.setHelpMessage(helpMessage);
    }

    private boolean isRequired() {
        return this.valuePairDefinition != null && this.valuePairDefinition.getDefaultValue() == null;
    }

    private boolean isEmpty(Object value) {
        return value == null || "".equals(value.toString().trim());
    }
}

