/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.enums;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.ValuePairEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.ValuePairEditorHandler;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.enums.EnumValuePairOptionEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.enums.EnumValuePairOptionEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.enums.MultipleEnumValuePairEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.enums.MultipleEnumValuePairEditorViewImpl;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.util.ValuePairEditorUtil;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.uberfire.commons.data.Pair;

public class MultipleEnumValuePairEditor
implements MultipleEnumValuePairEditorView.Presenter,
ValuePairEditor<List<String>> {
    private MultipleEnumValuePairEditorView view;
    private AnnotationValuePairDefinition valuePairDefinition;
    private ValuePairEditorHandler editorHandler;
    private Map<String, EnumValuePairOptionEditor> valueToEditor = new HashMap<String, EnumValuePairOptionEditor>();
    private static final String EMPTY_ARRAY = "_EMPTY_ARRAY_";
    private List<String> currentValues = null;

    public MultipleEnumValuePairEditor() {
        this((MultipleEnumValuePairEditorView)GWT.create(MultipleEnumValuePairEditorViewImpl.class));
    }

    public MultipleEnumValuePairEditor(MultipleEnumValuePairEditorView view) {
        this.view = view;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void init(AnnotationValuePairDefinition valuePairDefinition) {
        this.valuePairDefinition = valuePairDefinition;
        this.view.setValuePairLabel(ValuePairEditorUtil.buildValuePairLabel(valuePairDefinition));
        this.view.showValuePairRequiredIndicator(!valuePairDefinition.hasDefaultValue());
        this.initOptionEditors(this.createOptions(valuePairDefinition.enumValues()));
    }

    @Override
    public void clear() {
        this.setSelectedValues(new ArrayList<String>());
    }

    @Override
    public void addEditorHandler(ValuePairEditorHandler editorHandler) {
        this.editorHandler = editorHandler;
    }

    @Override
    public void setValue(List<String> value) {
        this.currentValues = value;
        this.setSelectedValues(value);
    }

    @Override
    public List<String> getValue() {
        return this.currentValues;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public AnnotationValuePairDefinition getValuePairDefinition() {
        return this.valuePairDefinition;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.view.setErrorMessage(errorMessage);
    }

    @Override
    public void clearErrorMessage() {
        this.view.clearErrorMessage();
    }

    @Override
    public void showValidateButton(boolean show) {
    }

    @Override
    public void showValuePairName(boolean show) {
    }

    @Override
    public void refresh() {
    }

    private List<Pair<String, String>> createOptions(String[] enumValues) {
        ArrayList<Pair<String, String>> items = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < enumValues.length; ++i) {
            items.add((Pair<String, String>)new Pair((Object)enumValues[i], (Object)enumValues[i]));
        }
        return items;
    }

    private void initOptionEditors(List<Pair<String, String>> options) {
        this.view.clear();
        if (options != null) {
            for (final Pair<String, String> option : options) {
                final EnumValuePairOptionEditor optionEditor = this.createOptionEditor((String)option.getK2());
                this.valueToEditor.put((String)option.getK2(), optionEditor);
                optionEditor.addEnumValuePairOptionEditorHandler(new EnumValuePairOptionEditorView.EnumValuePairOptionEditorHandler(){

                    @Override
                    public void onValueChange() {
                        MultipleEnumValuePairEditor.this.doOnValueChange((String)option.getK2(), optionEditor.getValue());
                        if (!MultipleEnumValuePairEditor.EMPTY_ARRAY.equals(option.getK2()) && optionEditor.getValue()) {
                            ((EnumValuePairOptionEditor)MultipleEnumValuePairEditor.this.valueToEditor.get(MultipleEnumValuePairEditor.EMPTY_ARRAY)).setValue(false);
                        }
                    }
                });
                this.view.addOptionEditor(optionEditor);
            }
        }
        final EnumValuePairOptionEditor emptyArrayEditor = this.createOptionEditor("{}");
        this.view.addOptionEditor(emptyArrayEditor);
        this.valueToEditor.put(EMPTY_ARRAY, emptyArrayEditor);
        emptyArrayEditor.addEnumValuePairOptionEditorHandler(new EnumValuePairOptionEditorView.EnumValuePairOptionEditorHandler(){

            @Override
            public void onValueChange() {
                MultipleEnumValuePairEditor.this.doOnValueChange(MultipleEnumValuePairEditor.EMPTY_ARRAY, emptyArrayEditor.getValue());
                if (emptyArrayEditor.getValue()) {
                    MultipleEnumValuePairEditor.this.uncheckOthers(MultipleEnumValuePairEditor.EMPTY_ARRAY);
                }
            }
        });
    }

    protected EnumValuePairOptionEditor createOptionEditor(String option) {
        return new EnumValuePairOptionEditor(option);
    }

    private void doOnValueChange(String valueName, boolean isChecked) {
        if (EMPTY_ARRAY.equals(valueName)) {
            this.currentValues = isChecked ? new ArrayList() : null;
        } else if (!isChecked) {
            this.safeRemoveValue(valueName);
        } else {
            this.safeAddValue(valueName);
        }
        if (this.editorHandler != null) {
            this.editorHandler.onValueChange();
        }
    }

    private void setSelectedValues(List<String> values) {
        for (EnumValuePairOptionEditor optionEditor : this.valueToEditor.values()) {
            optionEditor.setValue(false);
        }
        if (values != null) {
            if (values.size() == 0) {
                this.valueToEditor.get(EMPTY_ARRAY).setValue(true);
            } else {
                for (String value : values) {
                    EnumValuePairOptionEditor optionEditor = this.valueToEditor.get(value);
                    if (optionEditor == null) continue;
                    optionEditor.setValue(true);
                }
            }
        }
    }

    private void safeRemoveValue(String value) {
        if (this.currentValues != null) {
            this.currentValues.remove(value);
            if (this.currentValues.size() == 0) {
                this.currentValues = null;
            }
        }
    }

    private void safeAddValue(String value) {
        if (this.currentValues == null) {
            this.currentValues = new ArrayList<String>();
        }
        if (!this.currentValues.contains(value)) {
            this.currentValues.add(value);
        }
    }

    private void uncheckOthers(String value) {
        for (String key : this.valueToEditor.keySet()) {
            if (key.equals(value)) continue;
            this.valueToEditor.get(key).setValue(false);
        }
    }
}

