/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.multiple;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.ValuePairEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.ValuePairEditorHandler;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.multiple.MultipleValuePairEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.multiple.MultipleValuePairEditorViewImpl;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.util.ValuePairEditorUtil;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;

public abstract class MultipleValuePairEditor
implements MultipleValuePairEditorView.Presenter,
ValuePairEditor<List<?>> {
    private MultipleValuePairEditorView view;
    private List<Object> currentValue = null;
    private AnnotationValuePairDefinition valuePairDefinition;
    private ValuePairEditorHandler editorHandler;
    boolean valid = true;

    public MultipleValuePairEditor() {
        this((MultipleValuePairEditorView)GWT.create(MultipleValuePairEditorViewImpl.class));
    }

    public MultipleValuePairEditor(MultipleValuePairEditorView view) {
        this.view = view;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void init(AnnotationValuePairDefinition valuePairDefinition) {
        this.valuePairDefinition = valuePairDefinition;
        this.view.init(valuePairDefinition);
        this.view.setValuePairLabel(ValuePairEditorUtil.buildValuePairLabel(valuePairDefinition));
        this.view.showValuePairRequiredIndicator(!valuePairDefinition.hasDefaultValue());
    }

    @Override
    public List<?> getValue() {
        this.currentValue = null;
        if (this.calculateStatus()) {
            for (ValuePairEditor<?> itemEditor : this.view.getItemEditors()) {
                this.addSafeValue(itemEditor.getValue());
            }
        }
        return this.currentValue;
    }

    @Override
    public void setValue(List<?> value) {
        this.currentValue = new ArrayList<Object>();
        this.valid = true;
        if (value != null) {
            for (Object itemValue : value) {
                ValuePairEditor<?> valuePairEditor = this.createValuePairEditor(this.valuePairDefinition);
                this.view.addItemEditor(valuePairEditor);
                this.setEditorValue(valuePairEditor, itemValue);
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void clear() {
        this.view.clear();
    }

    @Override
    public void addEditorHandler(ValuePairEditorHandler editorHandler) {
        this.editorHandler = editorHandler;
    }

    @Override
    public AnnotationValuePairDefinition getValuePairDefinition() {
        return this.valuePairDefinition;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.view.setErrorMessage(errorMessage);
    }

    @Override
    public void clearErrorMessage() {
        this.view.clearErrorMessage();
    }

    @Override
    public void showValidateButton(boolean show) {
    }

    @Override
    public void showValuePairName(boolean show) {
    }

    @Override
    public void refresh() {
    }

    @Override
    public void onRemoveItem(Integer itemId) {
        this.view.removeItemEditor(itemId);
        this.valid = this.calculateStatus();
        this.notifyChange();
    }

    @Override
    public void onAddItem() {
        ValuePairEditor<?> addItemEditor = this.view.getAddItemEditor();
        if (!addItemEditor.isValid() || addItemEditor.getValue() == null) {
            this.view.showAlert(Constants.INSTANCE.advanced_domain_multiple_value_pair_editor_message_null_or_invalid());
        } else {
            ValuePairEditor<?> valuePairEditor = this.createValuePairEditor(this.valuePairDefinition);
            this.view.addItemEditor(valuePairEditor);
            this.setEditorValue(valuePairEditor, addItemEditor.getValue());
            addItemEditor.clear();
            addItemEditor.clearErrorMessage();
            this.notifyChange();
        }
    }

    @Override
    public void onValueChange(Integer itemId) {
        this.valid = this.calculateStatus();
        this.notifyChange();
    }

    @Override
    public abstract ValuePairEditor<?> createValuePairEditor(AnnotationValuePairDefinition var1);

    public abstract void setEditorValue(ValuePairEditor<?> var1, Object var2);

    private boolean calculateStatus() {
        for (ValuePairEditor<?> itemEditor : this.view.getItemEditors()) {
            if (itemEditor.isValid() && itemEditor.getValue() != null) continue;
            return false;
        }
        return true;
    }

    private void addSafeValue(Object value) {
        if (this.currentValue == null) {
            this.currentValue = new ArrayList<Object>();
        }
        this.currentValue.add(value);
    }

    private void notifyChange() {
        if (this.editorHandler != null) {
            this.editorHandler.onValueChange();
        }
    }
}

