/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain;

import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.BaseEditor;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldDeletedEvent;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;

public abstract class FieldEditor
extends BaseEditor {
    protected DataObject dataObject;
    protected ObjectProperty objectField;

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public ObjectProperty getObjectField() {
        return this.objectField;
    }

    public FieldEditor(DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
    }

    protected abstract void loadDataObjectField(DataObject var1, ObjectProperty var2);

    @Override
    public void onContextChange(DataModelerContext context) {
        super.onContextChange(context);
        if (context == null) {
            this.dataObject = null;
            this.objectField = null;
        } else {
            this.dataObject = context.getDataObject();
            this.objectField = context.getObjectProperty();
        }
        this.loadDataObjectField(this.dataObject, this.objectField);
    }

    protected void onDataObjectFieldChange(@Observes DataObjectFieldChangeEvent event) {
        if (event.isFromContext(this.context != null ? this.context.getContextId() : null) && !this.getName().equals(event.getSource())) {
            this.loadDataObjectField(event.getCurrentDataObject(), event.getCurrentField());
        }
    }

    protected void onDataObjectFieldDeleted(@Observes DataObjectFieldDeletedEvent event) {
        if (event.isFromContext(this.context != null ? this.context.getContextId() : null) && this.getDataObject() != null && this.getDataObject().getProperties().size() == 0) {
            this.clear();
            this.setReadonly(true);
        }
    }

    protected DataObjectFieldChangeEvent createFieldChangeEvent(ChangeType changeType) {
        DataObjectFieldChangeEvent changeEvent = new DataObjectFieldChangeEvent(changeType, this.getContext().getContextId(), this.getName(), this.getDataObject(), this.getObjectField(), null, null, null);
        return changeEvent;
    }
}

