/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.droolsdomain;

import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.FieldEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.droolsdomain.DroolsDataObjectFieldEditorView;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.uberfire.mvp.Command;

@Dependent
public class DroolsDataObjectFieldEditor
extends FieldEditor
implements DroolsDataObjectFieldEditorView.Presenter {
    private static int MAX_CLASS_FIELDS = 65535;
    private DroolsDataObjectFieldEditorView view;

    @Inject
    public DroolsDataObjectFieldEditor(DroolsDataObjectFieldEditorView view, DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.view = view;
        view.init(this);
    }

    @PostConstruct
    protected void init() {
        this.setReadonly(true);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public String getName() {
        return "DROOLS_FIELD_EDITOR";
    }

    @Override
    public String getDomainName() {
        return "DROOLS";
    }

    @Override
    public void setReadonly(boolean readonly) {
        super.setReadonly(readonly);
        this.view.setReadonly(readonly);
    }

    @Override
    public void clear() {
        this.view.setEquals(false);
        this.view.setPositionOnError(false);
        this.view.setPosition(null);
    }

    @Override
    protected void loadDataObjectField(DataObject dataObject, ObjectProperty objectField) {
        this.clear();
        this.setReadonly(true);
        if (dataObject != null && objectField != null) {
            this.dataObject = dataObject;
            this.objectField = objectField;
            Annotation annotation = objectField.getAnnotation("org.kie.api.definition.type.Key");
            if (annotation != null) {
                this.view.setEquals(Boolean.TRUE);
            }
            if ((annotation = objectField.getAnnotation("org.kie.api.definition.type.Position")) != null) {
                Object positionValue = annotation.getValue("value");
                String position = positionValue != null ? positionValue.toString() : "";
                this.view.setPosition(position);
            }
            this.setReadonly(this.getContext() == null || this.getContext().isReadonly());
        }
    }

    @Override
    public void onEqualsChange() {
        if (this.getObjectField() != null) {
            Boolean isChecked = this.view.getEquals();
            this.commandBuilder.buildFieldAddOrRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.kie.api.definition.type.Key", isChecked).execute();
        }
    }

    @Override
    public void onPositionChange() {
        if (this.getDataObject() != null) {
            this.view.setPositionOnError(false);
            Command afterCloseCommand = new Command(){

                public void execute() {
                    DroolsDataObjectFieldEditor.this.view.setPositionOnError(true);
                    DroolsDataObjectFieldEditor.this.view.selectAllPositionText();
                }
            };
            String newValue = DataModelerUtils.nullTrim(this.view.getPosition());
            if (newValue != null && !"".equals(newValue)) {
                int newPosition;
                String error = null;
                try {
                    newPosition = Integer.parseInt(newValue);
                }
                catch (NumberFormatException e) {
                    newPosition = -1;
                }
                if (newPosition < 0 || newPosition >= MAX_CLASS_FIELDS) {
                    error = Constants.INSTANCE.validation_error_position_greater_or_equal_than_and_lower_than(newValue, "0", MAX_CLASS_FIELDS + "");
                } else {
                    List<ObjectProperty> fieldsUsingPosition = this.getFieldsUsingPosition(newPosition);
                    if (fieldsUsingPosition.size() > 0) {
                        String fieldsUsingPositionNames = this.listNames(fieldsUsingPosition);
                        error = Constants.INSTANCE.validation_error_position_already_used_by_fields(newPosition + "", fieldsUsingPositionNames);
                    }
                }
                if (error != null) {
                    this.view.showErrorPopup(error, null, afterCloseCommand);
                } else {
                    this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.kie.api.definition.type.Position", "value", newPosition, false).execute();
                    this.view.setPosition(newPosition + "");
                }
            } else {
                this.commandBuilder.buildFieldAnnotationRemoveCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.kie.api.definition.type.Position").execute();
                this.view.setPosition(null);
            }
        }
    }

    private List<ObjectProperty> getFieldsUsingPosition(int position) {
        return DataModelerUtils.getFieldsUsingPosition(this.getDataObject(), position, this.getObjectField().getName());
    }

    private String listNames(List<ObjectProperty> fields) {
        StringBuilder names = new StringBuilder();
        boolean first = true;
        for (ObjectProperty property : fields) {
            if (!first) {
                names.append(", ");
            }
            names.append(property.getName());
            first = false;
        }
        return names.toString();
    }
}

