/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.properties;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.model.DataModelerPropertyEditorFieldInfo;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.properties.PropertyEditionPopup;
import org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.properties.IdGeneratorField;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

@Dependent
public class IdGeneratorEditionDialog
implements PropertyEditionPopup {
    private View view;
    private PropertyEditorFieldInfo property;
    private Command okCommand;

    @Inject
    public IdGeneratorEditionDialog(View view) {
        this.view = view;
    }

    @PostConstruct
    void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void show() {
        DataModelerPropertyEditorFieldInfo fieldInfo = (DataModelerPropertyEditorFieldInfo)this.property;
        String strategy = (String)fieldInfo.getCurrentValue("strategy");
        String generator = (String)fieldInfo.getCurrentValue("generator");
        strategy = strategy != null ? strategy : "NOT_SELECTED";
        this.view.setGeneratorType(strategy);
        this.view.setGeneratorName(generator);
        this.view.setEnabled(!fieldInfo.isDisabled());
        this.view.show();
    }

    @Override
    public void setOkCommand(Command okCommand) {
        this.okCommand = okCommand;
    }

    @Override
    public void setProperty(PropertyEditorFieldInfo property) {
        this.property = property;
    }

    @Override
    public String getStringValue() {
        return "NOT_SELECTED".equals(this.view.getGeneratorType()) ? IdGeneratorField.NOT_CONFIGURED_LABEL : this.view.getGeneratorType();
    }

    @Override
    public void setStringValue(String value) {
    }

    void onOK() {
        DataModelerPropertyEditorFieldInfo fieldInfo = (DataModelerPropertyEditorFieldInfo)this.property;
        fieldInfo.clearCurrentValues();
        String strategy = this.view.getGeneratorType();
        if (!"NOT_SELECTED".equals(strategy)) {
            fieldInfo.setCurrentValue("strategy", strategy);
            fieldInfo.setCurrentValue("generator", this.view.getGeneratorName());
        }
        this.view.hide();
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
    }

    void onCancel() {
        this.view.hide();
    }

    public static interface View
    extends IsWidget {
        public void init(IdGeneratorEditionDialog var1);

        public void setGeneratorType(String var1);

        public String getGeneratorType();

        public void setGeneratorName(String var1);

        public String getGeneratorName();

        public void setEnabled(boolean var1);

        public void show();

        public void hide();
    }
}

