/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.properties;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.model.DataModelerPropertyEditorFieldInfo;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.properties.PropertyEditionPopup;
import org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.properties.RelationshipField;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.CascadeType;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.FetchMode;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.RelationType;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

@Dependent
public class RelationshipEditionDialog
implements PropertyEditionPopup {
    private View view;
    private PropertyEditorFieldInfo property;
    private Command okCommand;
    private boolean cascadeAllWasClicked = false;

    @Inject
    public RelationshipEditionDialog(View view) {
        this.view = view;
    }

    @PostConstruct
    void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void show() {
        DataModelerPropertyEditorFieldInfo fieldInfo = (DataModelerPropertyEditorFieldInfo)this.property;
        RelationType relationTypeValue = (RelationType)fieldInfo.getCurrentValue("relationType");
        if (relationTypeValue != null) {
            this.view.setRelationType(relationTypeValue.name());
        } else {
            this.view.setRelationType("NOT_SELECTED");
        }
        this.enableRelationDependentFields(relationTypeValue);
        this.cascadeAllWasClicked = false;
        this.setCascadeTypes((List)fieldInfo.getCurrentValue("cascade"));
        this.enableCascadeTypes(true, true);
        FetchMode fetchModeValue = (FetchMode)fieldInfo.getCurrentValue("fetch");
        if (fetchModeValue != null) {
            this.view.setFetchMode(fetchModeValue.name());
        } else {
            this.view.setFetchMode("NOT_SELECTED");
        }
        Boolean optionalValue = (Boolean)fieldInfo.getCurrentValue("optional");
        if (optionalValue != null) {
            this.view.setOptional(optionalValue);
        }
        String mappedBy = (String)fieldInfo.getCurrentValue("mappedBy");
        this.view.setMappedBy(mappedBy);
        Boolean orphanRemovalValue = (Boolean)fieldInfo.getCurrentValue("orphanRemoval");
        if (orphanRemovalValue != null) {
            this.view.setOrphanRemoval(orphanRemovalValue);
        }
        this.view.setEnabled(!fieldInfo.isDisabled());
        this.view.show();
    }

    @Override
    public void setOkCommand(Command okCommand) {
        this.okCommand = okCommand;
    }

    @Override
    public void setProperty(PropertyEditorFieldInfo property) {
        this.property = property;
    }

    @Override
    public String getStringValue() {
        return "NOT_SELECTED".equals(this.view.getRelationType()) ? RelationshipField.NOT_CONFIGURED_LABEL : this.view.getRelationType();
    }

    @Override
    public void setStringValue(String value) {
    }

    void onRelationTypeChanged() {
        String strValue = this.view.getRelationType();
        if (!"NOT_SELECTED".equals(strValue)) {
            RelationType type = RelationType.valueOf((String)this.view.getRelationType());
            this.enableRelationDependentFields(type);
        }
    }

    void onCascadeAllChanged() {
        if (this.view.getCascadeAll()) {
            this.enableCascadeTypes(true, false);
            this.view.setCascadePersist(true);
            this.view.setCascadeMerge(true);
            this.view.setCascadeRemove(true);
            this.view.setCascadeRefresh(true);
            this.view.setCascadeDetach(true);
        } else {
            this.enableCascadeTypes(true, true);
            if (this.cascadeAllWasClicked) {
                this.view.setCascadePersist(false);
                this.view.setCascadeMerge(false);
                this.view.setCascadeRemove(false);
                this.view.setCascadeRefresh(false);
                this.view.setCascadeDetach(false);
            }
        }
        this.cascadeAllWasClicked = true;
    }

    void onOK() {
        DataModelerPropertyEditorFieldInfo fieldInfo = (DataModelerPropertyEditorFieldInfo)this.property;
        fieldInfo.clearCurrentValues();
        String relationType = this.view.getRelationType();
        if (!relationType.equals("NOT_SELECTED")) {
            fieldInfo.setCurrentValue("relationType", RelationType.valueOf((String)relationType));
            fieldInfo.setCurrentValue("cascade", this.getCascadeTypes());
            fieldInfo.setCurrentValue("fetch", FetchMode.valueOf((String)this.view.getFetchMode()));
            if (relationType.equals(RelationType.ONE_TO_ONE.name()) || relationType.equals(RelationType.MANY_TO_ONE.name())) {
                fieldInfo.setCurrentValue("optional", this.view.getOptional());
            }
            if (relationType.equals(RelationType.ONE_TO_ONE.name()) || relationType.equals(RelationType.ONE_TO_MANY.name()) || relationType.equals(RelationType.MANY_TO_MANY.name())) {
                fieldInfo.setCurrentValue("mappedBy", this.view.getMappedBy());
            }
            if (relationType.equals(RelationType.ONE_TO_ONE.name()) || relationType.equals(RelationType.ONE_TO_MANY.name())) {
                fieldInfo.setCurrentValue("orphanRemoval", this.view.getOrphanRemoval());
            }
        }
        this.view.hide();
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
    }

    void onCancel() {
        this.view.hide();
    }

    void enableRelationDependentFields(RelationType relationType) {
        if (relationType != null) {
            switch (relationType) {
                case ONE_TO_ONE: {
                    this.view.setOptionalVisible(true);
                    this.view.setMappedByVisible(true);
                    this.view.setOrphanRemovalVisible(true);
                    break;
                }
                case ONE_TO_MANY: {
                    this.view.setOptionalVisible(false);
                    this.view.setMappedByVisible(true);
                    this.view.setOrphanRemovalVisible(true);
                    break;
                }
                case MANY_TO_ONE: {
                    this.view.setOptionalVisible(true);
                    this.view.setMappedByVisible(false);
                    this.view.setOrphanRemovalVisible(false);
                    break;
                }
                case MANY_TO_MANY: {
                    this.view.setOptionalVisible(false);
                    this.view.setMappedByVisible(true);
                    this.view.setOrphanRemovalVisible(false);
                }
            }
        }
    }

    private void setCascadeTypes(List<CascadeType> cascadeTypes) {
        this.view.setCascadeAll(cascadeTypes != null && cascadeTypes.contains(CascadeType.ALL));
        this.view.setCascadePersist(cascadeTypes != null && cascadeTypes.contains(CascadeType.PERSIST));
        this.view.setCascadeMerge(cascadeTypes != null && cascadeTypes.contains(CascadeType.MERGE));
        this.view.setCascadeRemove(cascadeTypes != null && cascadeTypes.contains(CascadeType.REMOVE));
        this.view.setCascadeRefresh(cascadeTypes != null && cascadeTypes.contains(CascadeType.REFRESH));
        this.view.setCascadeDetach(cascadeTypes != null && cascadeTypes.contains(CascadeType.DETACH));
    }

    private List<CascadeType> getCascadeTypes() {
        ArrayList<CascadeType> cascadeTypes = new ArrayList<CascadeType>();
        if (this.view.getCascadeAll()) {
            cascadeTypes.add(CascadeType.ALL);
            if (this.cascadeAllWasClicked) {
                return cascadeTypes;
            }
        }
        if (this.view.getCascadePersist()) {
            cascadeTypes.add(CascadeType.PERSIST);
        }
        if (this.view.getCascadeMerge()) {
            cascadeTypes.add(CascadeType.MERGE);
        }
        if (this.view.getCascadeRemove()) {
            cascadeTypes.add(CascadeType.REMOVE);
        }
        if (this.view.getCascadeRefresh()) {
            cascadeTypes.add(CascadeType.REFRESH);
        }
        if (this.view.getCascadeDetach()) {
            cascadeTypes.add(CascadeType.DETACH);
        }
        return cascadeTypes;
    }

    private void enableCascadeTypes(boolean enableCascadeAll, boolean enableTheRest) {
        this.view.enableCascadeAll(enableCascadeAll);
        this.view.enableCascadePersist(enableTheRest);
        this.view.enableCascadeMerge(enableTheRest);
        this.view.enableCascadeRemove(enableTheRest);
        this.view.enableCascadeRefresh(enableTheRest);
        this.view.enableCascadeDetach(enableTheRest);
    }

    public static interface View
    extends IsWidget {
        public void init(RelationshipEditionDialog var1);

        public String getRelationType();

        public void setRelationType(String var1);

        public String getFetchMode();

        public void setFetchMode(String var1);

        public boolean getOptional();

        public void setOptional(boolean var1);

        public String getMappedBy();

        public void setMappedBy(String var1);

        public boolean getOrphanRemoval();

        public void setOrphanRemoval(boolean var1);

        public boolean getCascadeAll();

        public void setCascadeAll(boolean var1);

        public boolean getCascadePersist();

        public void setCascadePersist(boolean var1);

        public boolean getCascadeMerge();

        public void setCascadeMerge(boolean var1);

        public boolean getCascadeRemove();

        public void setCascadeRemove(boolean var1);

        public boolean getCascadeRefresh();

        public void setCascadeRefresh(boolean var1);

        public boolean getCascadeDetach();

        public void setCascadeDetach(boolean var1);

        public void setEnabled(boolean var1);

        public void enableCascadeAll(boolean var1);

        public void enableCascadePersist(boolean var1);

        public void enableCascadeMerge(boolean var1);

        public void enableCascadeRemove(boolean var1);

        public void enableCascadeRefresh(boolean var1);

        public void enableCascadeDetach(boolean var1);

        public void setOptionalVisible(boolean var1);

        public void setOrphanRemovalVisible(boolean var1);

        public void setMappedByVisible(boolean var1);

        public void show();

        public void hide();
    }
}

