/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.properties;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.model.DataModelerPropertyEditorFieldInfo;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.properties.PropertyEditionPopup;
import org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.properties.SequenceGeneratorField;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

@Dependent
public class SequenceGeneratorEditionDialog
implements PropertyEditionPopup {
    private View view;
    private PropertyEditorFieldInfo property;
    private Command okCommand;

    @Inject
    public SequenceGeneratorEditionDialog(View view) {
        this.view = view;
    }

    @PostConstruct
    void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void show() {
        DataModelerPropertyEditorFieldInfo fieldInfo = (DataModelerPropertyEditorFieldInfo)this.property;
        String sequenceName = (String)fieldInfo.getCurrentValue("sequenceName");
        String generatorName = (String)fieldInfo.getCurrentValue("name");
        Object initialValue = fieldInfo.getCurrentValue("initialValue");
        Object allocationSize = fieldInfo.getCurrentValue("allocationSize");
        this.view.setSequenceName(sequenceName);
        this.view.setGeneratorName(generatorName);
        this.view.setInitialValue(initialValue != null ? initialValue.toString() : null);
        this.view.clearInitialValueError();
        this.view.setAllocationSize(allocationSize != null ? allocationSize.toString() : null);
        this.view.clearAllocationSizeError();
        this.view.setEnabled(!fieldInfo.isDisabled());
        this.view.show();
    }

    @Override
    public void setOkCommand(Command okCommand) {
        this.okCommand = okCommand;
    }

    @Override
    public void setProperty(PropertyEditorFieldInfo property) {
        this.property = property;
    }

    void onOK() {
        DataModelerPropertyEditorFieldInfo fieldInfo = (DataModelerPropertyEditorFieldInfo)this.property;
        fieldInfo.clearCurrentValues();
        String generatorName = this.view.getGeneratorName();
        if (generatorName != null && !generatorName.isEmpty()) {
            fieldInfo.setCurrentValue("name", generatorName);
            fieldInfo.setCurrentValue("sequenceName", this.view.getSequenceName());
            fieldInfo.setCurrentValue("initialValue", this.getInitialValue());
            fieldInfo.setCurrentValue("allocationSize", this.getAllocationSize());
        }
        this.view.hide();
        if (this.okCommand != null) {
            this.okCommand.execute();
        }
    }

    private Integer getInitialValue() {
        return SequenceGeneratorEditionDialog.isNotEmpty(this.view.getInitialValue()) ? Integer.valueOf(Integer.parseInt(this.view.getInitialValue().trim())) : null;
    }

    private Integer getAllocationSize() {
        return SequenceGeneratorEditionDialog.isNotEmpty(this.view.getAllocationSize()) ? Integer.valueOf(Integer.parseInt(this.view.getAllocationSize().trim())) : null;
    }

    void onCancel() {
        this.view.hide();
    }

    void onInitialValueChange() {
        this.view.clearInitialValueError();
        this.view.enableOkAction(true);
        if (SequenceGeneratorEditionDialog.isInvalidValidInteger(this.view.getInitialValue())) {
            this.view.enableOkAction(false);
            this.view.setInitialValueError(Constants.INSTANCE.persistence_domain_relationship_sequence_generator_dialog_initial_value_error());
        }
    }

    void onAllocationSizeChange() {
        this.view.clearAllocationSizeError();
        this.view.enableOkAction(true);
        if (SequenceGeneratorEditionDialog.isInvalidValidInteger(this.view.getAllocationSize())) {
            this.view.enableOkAction(false);
            this.view.setAllocationSizeError(Constants.INSTANCE.persistence_domain_relationship_sequence_generator_dialog_allocation_size_error());
        }
    }

    @Override
    public String getStringValue() {
        String value = this.view.getGeneratorName();
        if (value == null || value.isEmpty()) {
            value = SequenceGeneratorField.NOT_CONFIGURED_LABEL;
        }
        return value;
    }

    @Override
    public void setStringValue(String value) {
    }

    private static boolean isInvalidValidInteger(String value) {
        if (SequenceGeneratorEditionDialog.isNotEmpty(value)) {
            try {
                Integer.parseInt(value.trim());
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    private static boolean isNotEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    public static interface View
    extends IsWidget {
        public void init(SequenceGeneratorEditionDialog var1);

        public String getGeneratorName();

        public void setGeneratorName(String var1);

        public String getSequenceName();

        public void setSequenceName(String var1);

        public String getInitialValue();

        public void setInitialValue(String var1);

        public void setInitialValueError(String var1);

        public void clearInitialValueError();

        public String getAllocationSize();

        public void setAllocationSize(String var1);

        public void setAllocationSizeError(String var1);

        public void clearAllocationSizeError();

        public void setEnabled(boolean var1);

        public void enableOkAction(boolean var1);

        public void show();

        public void hide();
    }
}

