/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.maindomain;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.command.DataObjectAnnotationValueChangeCommand;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.util.AnnotationValueHandler;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.client.validation.ValidatorService;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ObjectEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.maindomain.MainDataObjectEditorView;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.refactoring.client.usages.ShowAssetUsagesDisplayer;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;

@Dependent
public class MainDataObjectEditor
extends ObjectEditor
implements MainDataObjectEditorView.Presenter {
    private MainDataObjectEditorView view;
    private ValidatorService validatorService;
    private Caller<DataModelerService> modelerService;
    private ShowAssetUsagesDisplayer showAssetUsagesDisplayer;

    @Inject
    public MainDataObjectEditor(MainDataObjectEditorView view, DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder, ValidatorService validatorService, Caller<DataModelerService> modelerService, ShowAssetUsagesDisplayer showAssetUsagesDisplayer) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.view = view;
        this.validatorService = validatorService;
        this.modelerService = modelerService;
        this.showAssetUsagesDisplayer = showAssetUsagesDisplayer;
        view.init(this);
    }

    @PostConstruct
    protected void init() {
        this.setReadonly(true);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public String getName() {
        return "MAIN_OBJECT_EDITOR";
    }

    @Override
    public String getDomainName() {
        return "MAIN";
    }

    @Override
    public void onContextChange(DataModelerContext context) {
        this.context = context;
        this.view.initPackageSelector(context);
        super.onContextChange(context);
    }

    private DataModel getDataModel() {
        return this.getContext() != null ? this.getContext().getDataModel() : null;
    }

    public void refreshTypeList(boolean keepSelection) {
        this.initSuperClassList(keepSelection);
    }

    @Override
    public void setReadonly(boolean readonly) {
        super.setReadonly(readonly);
        this.view.setReadonly(readonly);
    }

    @Override
    public void onNameChange() {
        if (this.getDataObject() != null) {
            Path currentPath;
            this.view.setNameOnError(false);
            String packageName = this.getDataObject().getPackageName();
            String oldValue = this.getDataObject().getName();
            String newValue = this.view.getName();
            String originalClassName = this.getContext() != null ? this.getContext().getEditorModelContent().getOriginalClassName() : null;
            Path path = currentPath = this.getContext() != null && this.getContext().getEditorModelContent() != null ? this.getContext().getEditorModelContent().getPath() : null;
            if (originalClassName != null) {
                this.showAssetUsagesDisplayer.showAssetUsages(Constants.INSTANCE.modelEditor_confirm_renaming_of_used_class(originalClassName), currentPath, originalClassName, ResourceType.JAVA, () -> this.doClassNameChange(packageName, oldValue, newValue), () -> this.view.setName(oldValue));
            } else {
                this.doClassNameChange(packageName, oldValue, newValue);
            }
        }
    }

    @Override
    public void onLabelChange() {
        if (this.getDataObject() != null) {
            String value = DataModelerUtils.nullTrim(this.view.getLabel());
            DataObjectAnnotationValueChangeCommand command = this.commandBuilder.buildDataObjectAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), "org.kie.api.definition.type.Label", "value", value, true);
            command.execute();
        }
    }

    @Override
    public void onDescriptionChange() {
        if (this.getDataObject() != null) {
            String value = DataModelerUtils.nullTrim(this.view.getDescription());
            DataObjectAnnotationValueChangeCommand command = this.commandBuilder.buildDataObjectAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), "org.kie.api.definition.type.Description", "value", value, true);
            command.execute();
        }
    }

    @Override
    public void onSuperClassChange() {
        if (this.getDataObject() != null) {
            this.view.setSuperClassOnError(false);
            final String newSuperClass = this.view.getSuperClass();
            String oldSuperClass = this.getDataObject().getSuperClassName();
            if (("".equals(newSuperClass) || "NOT_SELECTED".equals(newSuperClass)) && oldSuperClass == null || newSuperClass.equals(oldSuperClass)) {
                return;
            }
            if (newSuperClass != null && !"".equals(newSuperClass) && !"NOT_SELECTED".equals(newSuperClass)) {
                this.validatorService.canExtend(this.getContext(), this.getDataObject().getClassName(), newSuperClass, new ValidatorCallback(){

                    public void onFailure() {
                        MainDataObjectEditor.this.view.showErrorPopup(Constants.INSTANCE.validation_error_cyclic_extension(MainDataObjectEditor.this.getDataObject().getClassName(), newSuperClass), null, new Command(){

                            public void execute() {
                                MainDataObjectEditor.this.view.setSuperClassOnError(true);
                                MainDataObjectEditor.this.view.setSuperClassOnFocus();
                            }
                        });
                    }

                    public void onSuccess() {
                        MainDataObjectEditor.this.commandBuilder.buildDataObjectSuperClassChangeCommand(MainDataObjectEditor.this.getContext(), MainDataObjectEditor.this.getName(), MainDataObjectEditor.this.getDataObject(), newSuperClass).execute();
                        MainDataObjectEditor.this.getDataObject().setSuperClassName(newSuperClass);
                    }
                });
            } else {
                this.commandBuilder.buildDataObjectSuperClassChangeCommand(this.getContext(), this.getName(), this.getDataObject(), null).execute();
            }
        }
    }

    @Override
    public void onPackageAdded() {
        if (this.getDataObject() != null) {
            this.doPackageChange(this.view.getNewPackageName());
        }
    }

    @Override
    public void onPackageChange() {
        if (this.getDataObject() != null) {
            this.doPackageChange(this.view.getPackageName());
        }
    }

    public void doPackageChange(String packageName) {
        if (this.getDataObject() != null) {
            Path currentPath;
            this.view.setPackageNameOnError(false);
            String originalClassName = this.getContext() != null ? this.getContext().getEditorModelContent().getOriginalClassName() : null;
            String newPackageName = packageName != null && !"".equals(packageName) && !"NOT_SELECTED".equals(packageName) ? packageName : null;
            String oldPackageName = this.getDataObject().getPackageName();
            Path path = currentPath = this.getContext() != null && this.getContext().getEditorModelContent() != null ? this.getContext().getEditorModelContent().getPath() : null;
            if (oldPackageName != null && !oldPackageName.equals(newPackageName) || oldPackageName == null && newPackageName != null) {
                this.showAssetUsagesDisplayer.showAssetUsages(Constants.INSTANCE.modelEditor_confirm_package_change_of_used_class(originalClassName), currentPath, originalClassName, ResourceType.JAVA, () -> this.doPackageChange(oldPackageName, newPackageName), () -> this.view.setPackageName(oldPackageName));
            } else {
                this.doPackageChange(oldPackageName, newPackageName);
            }
        }
    }

    @Override
    protected void loadDataObject(DataObject dataObject) {
        this.clear();
        this.setReadonly(true);
        if (dataObject != null) {
            this.dataObject = dataObject;
            this.view.setName(dataObject.getName());
            Annotation annotation = dataObject.getAnnotation("org.kie.api.definition.type.Label");
            if (annotation != null) {
                this.view.setLabel(AnnotationValueHandler.getStringValue(annotation, "value"));
            }
            if ((annotation = dataObject.getAnnotation("org.kie.api.definition.type.Description")) != null) {
                this.view.setDescription(AnnotationValueHandler.getStringValue(annotation, "value"));
            }
            this.view.setPackageName(dataObject.getPackageName());
            this.initSuperClassList(false);
            this.setReadonly(this.getContext() == null || this.getContext().isReadonly());
        }
    }

    private void initSuperClassList(boolean keepSelection) {
        String currentValue = keepSelection ? this.view.getSuperClass() : (this.dataObject != null ? this.dataObject.getSuperClassName() : null);
        this.view.initSuperClassList(DataModelerUtils.buildSuperclassOptions(this.getDataModel(), this.dataObject), currentValue);
    }

    private void doClassNameChange(final String packageName, String oldValue, final String newValue) {
        final Command afterCloseCommand = new Command(){

            public void execute() {
                MainDataObjectEditor.this.view.setNameOnError(true);
                MainDataObjectEditor.this.view.setAllNameNameText();
            }
        };
        if (oldValue.equals(newValue)) {
            this.view.setNameOnError(false);
            return;
        }
        this.validatorService.isValidIdentifier(newValue, new ValidatorCallback(){

            public void onFailure() {
                MainDataObjectEditor.this.view.showErrorPopup(Constants.INSTANCE.validation_error_invalid_object_identifier(newValue), null, afterCloseCommand);
            }

            public void onSuccess() {
                MainDataObjectEditor.this.validatorService.isUniqueEntityName(packageName, newValue, MainDataObjectEditor.this.getDataModel(), new ValidatorCallback(){

                    public void onFailure() {
                        MainDataObjectEditor.this.view.showErrorPopup(Constants.INSTANCE.validation_error_object_already_exists(newValue, packageName), null, afterCloseCommand);
                    }

                    public void onSuccess() {
                        MainDataObjectEditor.this.view.setNameOnError(false);
                        MainDataObjectEditor.this.commandBuilder.buildDataObjectNameChangeCommand(MainDataObjectEditor.this.getContext(), MainDataObjectEditor.this.getName(), MainDataObjectEditor.this.getDataObject(), newValue).execute();
                    }
                });
            }
        });
    }

    private void doPackageChange(String oldPackageName, String newPackageName) {
        this.commandBuilder.buildDataObjectPackageChangeCommand(this.getContext(), this.getName(), this.getDataObject(), newPackageName).execute();
    }

    @Override
    public void clear() {
        this.view.setNameOnError(false);
        this.view.setName(null);
        this.view.setLabel(null);
        this.view.setDescription(null);
        this.view.setPackageNameOnError(false);
        this.view.clearPackageList();
        this.view.clearSuperClassList();
        this.view.setSuperClassOnError(false);
    }
}

