/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.maindomain;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.command.FieldAnnotationValueChangeCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.FieldTypeChangeCommand;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.util.AnnotationValueHandler;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.client.validation.ValidatorService;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.FieldEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.maindomain.MainDataObjectFieldEditorView;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectChangeEvent;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.refactoring.client.usages.ShowAssetUsagesDisplayer;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;
import org.uberfire.mvp.Command;

@Dependent
public class MainDataObjectFieldEditor
extends FieldEditor
implements MainDataObjectFieldEditorView.Presenter {
    private MainDataObjectFieldEditorView view;
    private ValidatorService validatorService;
    private Caller<DataModelerService> modelerService;
    private ShowAssetUsagesDisplayer showAssetUsagesDisplayer;

    @Inject
    public MainDataObjectFieldEditor(MainDataObjectFieldEditorView view, DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder, ValidatorService validatorService, Caller<DataModelerService> modelerService, ShowAssetUsagesDisplayer showAssetUsagesDisplayer) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.view = view;
        this.validatorService = validatorService;
        this.modelerService = modelerService;
        this.showAssetUsagesDisplayer = showAssetUsagesDisplayer;
        view.init(this);
    }

    @PostConstruct
    protected void init() {
        this.setReadonly(true);
    }

    @Override
    public void onContextChange(DataModelerContext context) {
        this.context = context;
        this.initTypeList();
        this.view.setMultipleTypeEnabled(false);
        super.onContextChange(context);
    }

    @Override
    public String getName() {
        return "MAIN_FIELD_EDITOR";
    }

    @Override
    public String getDomainName() {
        return "MAIN";
    }

    private DataModel getDataModel() {
        return this.getContext() != null ? this.getContext().getDataModel() : null;
    }

    @Override
    public void setReadonly(boolean readonly) {
        super.setReadonly(readonly);
        this.view.setReadonly(readonly);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void onNameChange() {
        Path currentPath;
        if (this.getObjectField() == null) {
            return;
        }
        this.view.setNameOnError(false);
        String oldValue = this.getObjectField().getName();
        String newValue = DataModelerUtils.unCapitalize(this.view.getName());
        String originalClassName = this.getContext() != null ? this.getContext().getEditorModelContent().getOriginalClassName() : null;
        Path path = currentPath = this.getContext() != null && this.getContext().getEditorModelContent() != null ? this.getContext().getEditorModelContent().getPath() : null;
        if (originalClassName != null) {
            this.showAssetUsagesDisplayer.showAssetPartUsages(Constants.INSTANCE.modelEditor_confirm_renaming_of_used_field(oldValue), currentPath, originalClassName, oldValue, PartType.FIELD, () -> this.doFieldNameChange(oldValue, newValue), () -> this.view.setName(oldValue));
        } else {
            this.doFieldNameChange(oldValue, newValue);
        }
    }

    @Override
    public void onLabelChange() {
        if (this.getObjectField() != null) {
            String value = DataModelerUtils.nullTrim(this.view.getLabel());
            FieldAnnotationValueChangeCommand command = this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.kie.api.definition.type.Label", "value", value, true);
            command.execute();
        }
    }

    @Override
    public void onDescriptionChange() {
        if (this.getObjectField() != null) {
            String value = DataModelerUtils.nullTrim(this.view.getDescription());
            FieldAnnotationValueChangeCommand command = this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), "org.kie.api.definition.type.Description", "value", value, true);
            command.execute();
        }
    }

    @Override
    public void onTypeChange() {
        this.doTypeChange(this.view.getType(), this.view.getMultipleType());
    }

    @Override
    public void onTypeMultipleChange() {
        this.doTypeChange(this.view.getType(), this.view.getMultipleType());
    }

    private void onDataObjectChange(@Observes DataObjectChangeEvent event) {
        if (event.isFromContext(this.context != null ? this.context.getContextId() : null) && ("name".equals(event.getValueName()) || "packageName".equals(event.getValueName()) || "label".equals(event.getValueName()))) {
            this.initTypeList();
        }
    }

    @Override
    protected void loadDataObjectField(DataObject dataObject, ObjectProperty objectField) {
        this.clear();
        this.setReadonly(true);
        if (dataObject != null && objectField != null) {
            this.dataObject = dataObject;
            this.objectField = objectField;
            this.initTypeList();
            this.view.setName(this.getObjectField().getName());
            Annotation annotation = objectField.getAnnotation("org.kie.api.definition.type.Label");
            if (annotation != null) {
                this.view.setLabel(AnnotationValueHandler.getStringValue(annotation, "value"));
            }
            if ((annotation = objectField.getAnnotation("org.kie.api.definition.type.Description")) != null) {
                this.view.setDescription(AnnotationValueHandler.getStringValue(annotation, "value"));
            }
            this.setReadonly(this.getContext() == null || this.getContext().isReadonly());
        } else {
            this.initTypeList();
        }
    }

    private void doFieldNameChange(final String oldValue, final String newValue) {
        final Command afterCloseCommand = new Command(){

            public void execute() {
                MainDataObjectFieldEditor.this.view.setNameOnError(true);
                MainDataObjectFieldEditor.this.view.selectAllNameText();
            }
        };
        if (oldValue.equalsIgnoreCase(this.view.getName())) {
            this.view.setName(oldValue);
            this.view.setNameOnError(false);
            return;
        }
        this.validatorService.isValidIdentifier(newValue, new ValidatorCallback(){

            public void onFailure() {
                MainDataObjectFieldEditor.this.view.showErrorPopup(Constants.INSTANCE.validation_error_invalid_object_attribute_identifier(newValue), null, afterCloseCommand);
            }

            public void onSuccess() {
                MainDataObjectFieldEditor.this.validatorService.isUniqueAttributeName(newValue, MainDataObjectFieldEditor.this.getDataObject(), new ValidatorWithReasonCallback(){

                    public void onFailure() {
                        this.showFailure("MANAGED_PROPERTY_EXISTS");
                    }

                    public void onFailure(String reason) {
                        this.showFailure(reason);
                    }

                    private void showFailure(String reason) {
                        if ("UN_MANAGED_PROPERTY_EXISTS".equals(reason)) {
                            ObjectProperty unmanagedProperty = MainDataObjectFieldEditor.this.getDataObject().getUnManagedProperty(newValue);
                            MainDataObjectFieldEditor.this.view.showErrorPopup(Constants.INSTANCE.validation_error_object_un_managed_attribute_already_exists(unmanagedProperty.getName(), unmanagedProperty.getClassName()));
                        } else {
                            MainDataObjectFieldEditor.this.view.showErrorPopup(Constants.INSTANCE.validation_error_object_attribute_already_exists(newValue));
                        }
                    }

                    public void onSuccess() {
                        MainDataObjectFieldEditor.this.view.setNameOnError(false);
                        MainDataObjectFieldEditor.this.objectField.setName(newValue);
                        MainDataObjectFieldEditor.this.notifyChange((DataModelerEvent)MainDataObjectFieldEditor.this.createFieldChangeEvent(ChangeType.FIELD_NAME_CHANGE).withOldValue((Object)oldValue).withNewValue((Object)newValue));
                    }
                });
            }
        });
    }

    private void doTypeChange(String newType, boolean isMultiple) {
        if (this.getObjectField() != null) {
            boolean multiple = isMultiple;
            if (this.getContext().getHelper().isPrimitiveType(newType).booleanValue()) {
                this.view.setMultipleTypeEnabled(false);
                this.view.setMultipleType(false);
                multiple = false;
            } else {
                this.view.setMultipleTypeEnabled(true);
            }
            FieldTypeChangeCommand command = this.commandBuilder.buildChangeTypeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), newType, multiple);
            command.execute();
            this.executePostCommandProcessing(command);
        }
    }

    private void initTypeList() {
        String currentFieldType = null;
        boolean currentFieldTypeMultiple = false;
        this.view.setMultipleTypeEnabled(true);
        this.view.setMultipleType(false);
        if (this.getDataModel() != null) {
            if (this.getDataObject() != null && this.getObjectField() != null) {
                currentFieldType = this.getObjectField().getClassName();
                currentFieldTypeMultiple = this.getObjectField().isMultiple();
                if (this.getContext().getHelper().isPrimitiveType(currentFieldType).booleanValue()) {
                    this.view.setMultipleTypeEnabled(false);
                    this.view.setMultipleType(false);
                } else {
                    this.view.setMultipleType(currentFieldTypeMultiple);
                }
            }
            List<Pair<String, String>> typeList = DataModelerUtils.buildFieldTypeOptions(this.getContext().getHelper().getOrderedBaseTypes().values(), this.getDataModel().getDataObjects(), this.getDataModel().getJavaEnums(), this.getDataModel().getExternalClasses(), this.getDataModel().getDependencyJavaEnums(), currentFieldType, false);
            this.view.initTypeList(typeList, currentFieldType, false);
        } else {
            this.view.initTypeList(new ArrayList<Pair<String, String>>(), null, false);
        }
    }

    public void refreshTypeList(boolean keepSelection) {
        String selectedValue = this.view.getType();
        this.initTypeList();
        if (keepSelection && selectedValue != null) {
            this.view.setType(selectedValue);
        }
    }

    @Override
    public void clear() {
        this.view.setNameOnError(false);
        this.view.setName(null);
        this.view.setLabel(null);
        this.view.setDescription(null);
        this.view.setType("");
    }
}

