/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.packageselector;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.kie.workbench.common.screens.datamodeller.client.util.UIUtil;
import org.kie.workbench.common.screens.datamodeller.client.widgets.packageselector.NewPackagePopup;
import org.kie.workbench.common.screens.datamodeller.client.widgets.packageselector.PackageSelectorView;
import org.uberfire.commons.data.Pair;
import org.uberfire.mvp.Command;

@Dependent
public class PackageSelectorViewImpl
extends Composite
implements PackageSelectorView {
    private static PackageSelectorUIBinder uiBinder = (PackageSelectorUIBinder)GWT.create(PackageSelectorUIBinder.class);
    @UiField
    Select packageSelector;
    @UiField
    Button newPackage;
    NewPackagePopup newPackagePopup;
    private PackageSelectorView.Presenter presenter;

    @Inject
    public PackageSelectorViewImpl(NewPackagePopup newPackagePopup) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.newPackagePopup = newPackagePopup;
    }

    @PostConstruct
    private void init() {
        this.packageSelector.addValueChangeHandler(e -> this.presenter.onPackageChange());
        this.newPackage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PackageSelectorViewImpl.this.presenter.onNewPackage();
            }
        });
        this.clear();
    }

    public void init(PackageSelectorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void clear() {
        UIUtil.initList(this.packageSelector, true);
    }

    @Override
    public void initPackageList(List<Pair<String, String>> packageList, String selectedPackage, boolean enableEmptyPackageOption) {
        UIUtil.initList(this.packageSelector, packageList, selectedPackage, enableEmptyPackageOption);
    }

    @Override
    public void addToPackageList(String packageName, boolean selected) {
        this.packageSelector.add((Widget)UIUtil.newOption(packageName, packageName));
        if (selected) {
            UIUtil.setSelectedValue(this.packageSelector, packageName);
        }
        UIUtil.refreshSelect(this.packageSelector);
    }

    @Override
    public void showNewPackagePopup(Command afterAddCommand) {
        this.newPackagePopup.show(afterAddCommand);
    }

    @Override
    public String getNewPackage() {
        return this.newPackagePopup.getPackageName();
    }

    @Override
    public void enableCreatePackage(boolean enable) {
        this.newPackage.setVisible(enable);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.newPackage.setVisible(enabled);
        this.packageSelector.setEnabled(enabled);
        UIUtil.refreshSelect(this.packageSelector);
    }

    @Override
    public String getPackage() {
        return this.packageSelector.getValue();
    }

    @Override
    public void setPackage(String currentPackage) {
        UIUtil.setSelectedValue(this.packageSelector, currentPackage);
    }

    static interface PackageSelectorUIBinder
    extends UiBinder<Widget, PackageSelectorViewImpl> {
    }
}

