/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor.AdvancedAnnotationListEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.annotationlisteditor.item.AnnotationListItem;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.ValuePairEditorPopup;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.ValuePairEditorPopupView;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.core.ElementType;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationParseRequest;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationParseResponse;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSource;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSourceRequest;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSourceResponse;
import org.kie.workbench.common.services.datamodeller.driver.model.DriverError;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.mvp.Command;

@Dependent
public class AdvancedAnnotationListEditor
implements IsWidget,
AdvancedAnnotationListEditorView.Presenter {
    private AdvancedAnnotationListEditorView view;
    private AdvancedAnnotationListEditorView.DeleteAnnotationHandler deleteAnnotationHandler;
    private AdvancedAnnotationListEditorView.ClearValuePairHandler clearValuePairHandler;
    private AdvancedAnnotationListEditorView.ValuePairChangeHandler valuePairChangeHandler;
    private AdvancedAnnotationListEditorView.AddAnnotationHandler addAnnotationHandler;
    private Caller<DataModelerService> modelerService;
    private Instance<ValuePairEditorPopup> valuePairEditorInstance;
    private Instance<AnnotationListItem> itemInstance;
    private Map<String, AnnotationSource> annotationSources;
    private List<Annotation> annotations;
    private Map<Annotation, AnnotationListItem> annotationItems = new HashMap<Annotation, AnnotationListItem>();
    private Map<String, Boolean> annotationStatus = new HashMap<String, Boolean>();
    private KieProject project;
    private ElementType elementType;
    private boolean readonly = false;
    private Callback<Annotation> addAnnotationCallback;

    @Inject
    public AdvancedAnnotationListEditor(AdvancedAnnotationListEditorView view, Caller<DataModelerService> modelerService, Instance<ValuePairEditorPopup> valuePairEditorInstance, Instance<AnnotationListItem> itemInstance) {
        this.view = view;
        view.init(this);
        this.modelerService = modelerService;
        this.valuePairEditorInstance = valuePairEditorInstance;
        this.itemInstance = itemInstance;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void init(KieProject project, ElementType elementType) {
        this.project = project;
        this.elementType = elementType;
    }

    public void loadAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
        if (annotations != null && annotations.size() > 0) {
            AnnotationSourceRequest sourceRequest = new AnnotationSourceRequest();
            sourceRequest.withAnnotations(annotations);
            ((DataModelerService)this.modelerService.call(this.getLoadAnnotationSourcesSuccessCallback())).resolveSourceRequest(sourceRequest);
        }
    }

    public void loadAnnotations(List<Annotation> annotations, Map<String, AnnotationSource> annotationSources) {
        this.view.clear();
        this.clearListItems();
        this.annotationSources = annotationSources;
        if (annotations != null) {
            Iterator<Annotation> iterator = annotations.iterator();
            while (iterator.hasNext()) {
                Annotation annotation;
                Annotation currentAnnotation = annotation = iterator.next();
                AnnotationListItem annotationListItem = this.createListItem();
                annotationListItem.loadAnnotation(annotation, annotationSources != null ? annotationSources.get(annotation.getClassName()) : null);
                annotationListItem.setCollapsed(!this.isExpanded(annotation.getClassName()));
                annotationListItem.setDeleteAnnotationHandler(this::onDeleteAnnotation);
                annotationListItem.setClearValuePairHandler(this::onClearValuePair);
                annotationListItem.setEditValuePairHandler(this::onEditValuePair);
                annotationListItem.setCollapseChangeHandler(() -> this.onCollapseChange(currentAnnotation, annotationListItem.isCollapsed()));
                annotationListItem.setReadonly(this.readonly);
                this.annotationItems.put(annotation, annotationListItem);
                this.view.addItem(annotationListItem);
            }
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.view.setReadonly(readonly);
        for (AnnotationListItem annotationListItem : this.annotationItems.values()) {
            annotationListItem.setReadonly(readonly);
        }
    }

    @Override
    public void onAddAnnotation() {
        this.view.invokeCreateAnnotationWizard(this.getAddAnnotationCallback(), this.project, this.elementType);
    }

    protected Callback<Annotation> getAddAnnotationCallback() {
        return annotation -> {
            if (annotation != null && this.addAnnotationHandler != null) {
                this.addAnnotationHandler.onAddAnnotation((Annotation)annotation);
            }
        };
    }

    protected void onDeleteAnnotation(Annotation annotation) {
        String message = Constants.INSTANCE.advanced_domain_annotation_list_editor_message_confirm_annotation_deletion(annotation.getClassName(), this.elementType != null ? this.elementType.name() : " object/field");
        this.view.showYesNoDialog(message, this.getDeleteAnnotationCommand(annotation), this.getNoActionCommand(), this.getNoActionCommand());
    }

    protected Command getDeleteAnnotationCommand(Annotation annotation) {
        return () -> {
            if (this.deleteAnnotationHandler != null) {
                this.deleteAnnotationHandler.onDeleteAnnotation(annotation);
            }
        };
    }

    protected Command getNoActionCommand() {
        return () -> {};
    }

    protected void onEditValuePair(Annotation annotation, String valuePair) {
        ValuePairEditorPopup valuePairEditor = this.createValuePairEditor(annotation, valuePair);
        if (valuePairEditor.isGenericEditor()) {
            AnnotationSource annotationSource = this.annotationSources.get(annotation.getClassName());
            String valuePairSource = annotationSource != null ? annotationSource.getValuePairSource(valuePair) : null;
            valuePairEditor.setValue(valuePairSource);
        } else {
            valuePairEditor.setValue(annotation.getValue(valuePair));
        }
        valuePairEditor.show();
    }

    protected void onClearValuePair(Annotation annotation, String valuePair) {
        AnnotationDefinition annotationDefinition = annotation.getAnnotationDefinition();
        AnnotationValuePairDefinition valuePairDefinition = annotationDefinition.getValuePair(valuePair);
        if (valuePairDefinition.getDefaultValue() == null) {
            String message = Constants.INSTANCE.advanced_domain_annotation_list_editor_message_value_pair_has_no_default_value(valuePair, annotation.getClassName());
            this.view.showYesNoDialog(message, this.getNoActionCommand());
        } else if (this.clearValuePairHandler != null) {
            this.clearValuePairHandler.onClearValuePair(annotation, valuePair);
        }
    }

    protected void onCollapseChange(Annotation currentAnnotation, boolean collapsed) {
        this.setExpanded(currentAnnotation.getClassName(), !collapsed);
    }

    public void addDeleteAnnotationHandler(AdvancedAnnotationListEditorView.DeleteAnnotationHandler deleteAnnotationHandler) {
        this.deleteAnnotationHandler = deleteAnnotationHandler;
    }

    public void addClearValuePairHandler(AdvancedAnnotationListEditorView.ClearValuePairHandler clearValuePairHandler) {
        this.clearValuePairHandler = clearValuePairHandler;
    }

    public void addValuePairChangeHandler(AdvancedAnnotationListEditorView.ValuePairChangeHandler valuePairChangeHandler) {
        this.valuePairChangeHandler = valuePairChangeHandler;
    }

    public void addAddAnnotationHandler(AdvancedAnnotationListEditorView.AddAnnotationHandler addAnnotationHandler) {
        this.addAnnotationHandler = addAnnotationHandler;
    }

    public void clear() {
        this.view.clear();
        this.clearListItems();
    }

    public void removeAnnotation(Annotation annotation) {
        AnnotationListItem listItem = this.annotationItems.get(annotation);
        if (listItem != null) {
            this.view.removeItem(listItem);
            this.annotationItems.remove(annotation);
            this.dispose(listItem);
        }
    }

    private RemoteCallback<AnnotationSourceResponse> getLoadAnnotationSourcesSuccessCallback() {
        return annotationSourceResponse -> this.loadAnnotations(this.annotations, annotationSourceResponse.getAnnotationSources());
    }

    protected void doValuePairChange(ValuePairEditorPopup valuePairEditor, Object value) {
        if (valuePairEditor.isGenericEditor()) {
            String strValue = value != null ? value.toString() : null;
            ((DataModelerService)this.modelerService.call(this.getValuePairChangeSuccessCallback(valuePairEditor))).resolveParseRequest(new AnnotationParseRequest(valuePairEditor.getAnnotationClassName(), this.elementType, valuePairEditor.getValuePairDefinition().getName(), strValue), this.project);
        } else {
            this.applyValuePairChange(valuePairEditor, value);
        }
    }

    protected void doValuePairNoAction(ValuePairEditorPopup valuePairEditor) {
        valuePairEditor.hide();
        this.dispose(valuePairEditor);
    }

    private RemoteCallback<AnnotationParseResponse> getValuePairChangeSuccessCallback(ValuePairEditorPopup valuePairEditor) {
        return annotationParseResponse -> {
            if (!annotationParseResponse.hasErrors() && annotationParseResponse.getAnnotation() != null) {
                Object newValue = annotationParseResponse.getAnnotation().getValue(valuePairEditor.getValuePairDefinition().getName());
                this.applyValuePairChange(valuePairEditor, newValue);
            } else {
                String errorMessage = "";
                for (DriverError error : annotationParseResponse.getErrors()) {
                    errorMessage = errorMessage + "\n" + error.getMessage();
                }
                valuePairEditor.setErrorMessage(errorMessage);
            }
        };
    }

    private void applyValuePairChange(ValuePairEditorPopup valuePairEditor, Object newValue) {
        if (!valuePairEditor.isValid()) {
            valuePairEditor.setErrorMessage(Constants.INSTANCE.advanced_domain_annotation_list_editor_message_invalid_value_for_value_pair(valuePairEditor.getValuePairDefinition().getName()));
        } else if (!valuePairEditor.getValuePairDefinition().hasDefaultValue() && newValue == null) {
            valuePairEditor.setErrorMessage(Constants.INSTANCE.advanced_domain_annotation_list_editor_message_value_pair_cant_be_null(valuePairEditor.getValuePairDefinition().getName()));
        } else {
            this.valuePairChangeHandler.onValuePairChange(valuePairEditor.getAnnotationClassName(), valuePairEditor.getValuePairDefinition().getName(), newValue);
            valuePairEditor.hide();
            this.dispose(valuePairEditor);
        }
    }

    private ValuePairEditorPopup createValuePairEditor(Annotation annotation, String valuePair) {
        final ValuePairEditorPopup valuePairEditor = this.createValuePairEditor();
        valuePairEditor.init(annotation.getClassName(), annotation.getAnnotationDefinition().getValuePair(valuePair));
        valuePairEditor.addPopupHandler(new ValuePairEditorPopupView.ValuePairEditorPopupHandler(){

            @Override
            public void onOk() {
                AdvancedAnnotationListEditor.this.doValuePairChange(valuePairEditor, valuePairEditor.getValue());
            }

            @Override
            public void onCancel() {
                AdvancedAnnotationListEditor.this.doValuePairNoAction(valuePairEditor);
            }

            @Override
            public void onClose() {
                AdvancedAnnotationListEditor.this.doValuePairNoAction(valuePairEditor);
            }
        });
        return valuePairEditor;
    }

    @PreDestroy
    protected void destroy() {
        this.clearListItems();
    }

    protected AnnotationListItem createListItem() {
        return (AnnotationListItem)this.itemInstance.get();
    }

    private void clearListItems() {
        for (AnnotationListItem item : this.annotationItems.values()) {
            this.dispose(item);
        }
        this.annotationItems.clear();
    }

    private void dispose(AnnotationListItem listItem) {
        this.itemInstance.destroy((Object)listItem);
    }

    protected ValuePairEditorPopup createValuePairEditor() {
        return (ValuePairEditorPopup)this.valuePairEditorInstance.get();
    }

    private void dispose(ValuePairEditorPopup valuePairEditor) {
        this.valuePairEditorInstance.destroy((Object)valuePairEditor);
    }

    private boolean isExpanded(String annotation) {
        return this.annotationStatus.get(annotation) != null ? this.annotationStatus.get(annotation) : false;
    }

    private void setExpanded(String annotation, boolean expanded) {
        this.annotationStatus.put(annotation, expanded);
    }
}

