/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.string;

import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.string.AbstractStringValuePairEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.string.AbstractStringValuePairEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.util.ValuePairEditorUtil;

public class CharacterValuePairEditor
extends AbstractStringValuePairEditor {
    private boolean valid = true;

    public CharacterValuePairEditor() {
    }

    public CharacterValuePairEditor(AbstractStringValuePairEditorView view) {
        super(view);
    }

    @Override
    public void onValueChange() {
        String originalCurrentValue = this.view.getValue();
        this.currentValue = this.trimCharValue(originalCurrentValue);
        if (originalCurrentValue != null && !originalCurrentValue.equals(this.currentValue)) {
            this.view.setValue(this.currentValue);
        }
        boolean bl = this.valid = this.currentValue == null || ValuePairEditorUtil.isValidCharacterLiteral(this.currentValue);
        if (this.valid) {
            this.view.clearErrorMessage();
        } else {
            this.view.setErrorMessage(Constants.INSTANCE.character_value_pair_editor_invalid_character_message());
        }
        if (this.editorHandler != null) {
            this.editorHandler.onValueChange();
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValue(String value) {
        super.setValue(ValuePairEditorUtil.unquoteCharacterLiteral(value));
    }

    private String trimCharValue(String charValue) {
        if (charValue == null || "".equals(charValue)) {
            return null;
        }
        if (ValuePairEditorUtil.isBlankCharaterSequence(charValue)) {
            return Character.toString(' ');
        }
        return charValue.trim();
    }
}

