/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerValueChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectChangeEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectFieldChangeEvent;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;

@ApplicationScoped
public class DataModelChangeNotifier {
    private Event<DataModelerEvent> dataModelerEvent;

    @Inject
    public DataModelChangeNotifier(Event<DataModelerEvent> dataModelerEvent) {
        this.dataModelerEvent = dataModelerEvent;
    }

    public void notifyObjectChange(ChangeType changeType, DataModelerContext context, String source, DataObject dataObject, String annotationClassName, String memberName, Object oldValue, Object newValue) {
        DataObjectChangeEvent changeEvent = new DataObjectChangeEvent(changeType, context.getContextId(), source, dataObject, memberName, oldValue, newValue);
        changeEvent.withAnnotationClassName(annotationClassName);
        this.dataModelerEvent.fire((Object)changeEvent);
    }

    public void notifyFieldChange(ChangeType changeType, DataModelerContext context, String source, DataObject dataObject, ObjectProperty field, String annotationClassName, String memberName, Object oldValue, Object newValue) {
        DataObjectFieldChangeEvent changeEvent = new DataObjectFieldChangeEvent(changeType, context.getContextId(), source, dataObject, field, memberName, oldValue, newValue);
        changeEvent.withAnnotationClassName(annotationClassName);
        this.dataModelerEvent.fire((Object)changeEvent);
        context.getHelper().dataModelChanged((DataModelerValueChangeEvent)changeEvent);
    }

    protected void notifyChange(DataModelerEvent event) {
        this.dataModelerEvent.fire((Object)event);
    }
}

