/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.validation;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerErrorCallback;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.ext.editor.commons.client.validation.ValidatorWithReasonCallback;

@ApplicationScoped
public class ValidatorService {
    private Caller<ValidationService> validationService;
    public static final String MANAGED_PROPERTY_EXISTS = "MANAGED_PROPERTY_EXISTS";
    public static final String UN_MANAGED_PROPERTY_EXISTS = "UN_MANAGED_PROPERTY_EXISTS";

    @Inject
    public ValidatorService(Caller<ValidationService> validationService) {
        this.validationService = validationService;
    }

    public void isValidIdentifier(final String identifier, final ValidatorCallback callback) {
        ((ValidationService)this.validationService.call((RemoteCallback)new RemoteCallback<Map<String, Boolean>>(){

            public void callback(Map<String, Boolean> evaluated) {
                Boolean b = evaluated.get(identifier);
                if (Boolean.TRUE.equals(b)) {
                    callback.onSuccess();
                } else {
                    callback.onFailure();
                }
            }
        }, (ErrorCallback)new DataModelerErrorCallback("An error occurred during the server validation process"))).evaluateJavaIdentifiers(new String[]{identifier});
    }

    public void isValidPackageIdentifier(String identifier, final ValidatorCallback callback) {
        String[] packageTerms = DataModelerUtils.getPackageTerms(identifier);
        ((ValidationService)this.validationService.call((RemoteCallback)new RemoteCallback<Map<String, Boolean>>(){

            public void callback(Map<String, Boolean> evaluatedTerms) {
                boolean nok = evaluatedTerms.containsValue(Boolean.FALSE);
                if (nok) {
                    callback.onFailure();
                } else {
                    callback.onSuccess();
                }
            }
        }, (ErrorCallback)new DataModelerErrorCallback("An error occurred during the server validation process"))).evaluateJavaIdentifiers(packageTerms);
    }

    public void isValidTimerInterval(String expression, final ValidatorCallback callback) {
        if (expression == null || expression.length() > 0 && "".equals(expression.trim())) {
            callback.onFailure();
        } else {
            ((ValidationService)this.validationService.call((RemoteCallback)new RemoteCallback<Boolean>(){

                public void callback(Boolean value) {
                    if (Boolean.TRUE.equals(value)) {
                        callback.onSuccess();
                    } else {
                        callback.onFailure();
                    }
                }
            })).isTimerIntervalValid(expression);
        }
    }

    public void isUniqueEntityName(String packageName, String name, DataModel model, ValidatorCallback callback) {
        Boolean b = Boolean.TRUE;
        String className = DataModelerUtils.assembleClassName(packageName, name);
        for (DataObject d : model.getDataObjects()) {
            if (!d.getClassName().equals(className)) continue;
            b = Boolean.FALSE;
            break;
        }
        if (b.booleanValue()) {
            callback.onSuccess();
        } else {
            callback.onFailure();
        }
    }

    public void isUniqueAttributeName(String name, DataObject object, ValidatorWithReasonCallback callback) {
        for (ObjectProperty prop : object.getProperties()) {
            if (!prop.getName().equalsIgnoreCase(name)) continue;
            callback.onFailure(MANAGED_PROPERTY_EXISTS);
            return;
        }
        for (ObjectProperty unmanagedProp : object.getUnmanagedProperties()) {
            if (!unmanagedProp.getName().equalsIgnoreCase(name)) continue;
            callback.onFailure(UN_MANAGED_PROPERTY_EXISTS);
            return;
        }
        callback.onSuccess();
    }

    public void canExtend(DataModelerContext context, String siblingCandidateName, String parentCandidateName, ValidatorCallback callback) {
        if (context.getHelper().isAssignableFrom(siblingCandidateName, parentCandidateName).booleanValue()) {
            callback.onSuccess();
        } else {
            callback.onFailure();
        }
    }

    public void isValidPosition(String position, ValidatorCallback callback) {
        int i = -1;
        if (position == null || position.length() == 0) {
            i = 0;
        }
        try {
            i = Integer.parseInt(position, 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (i < 0) {
            callback.onFailure();
        } else {
            callback.onSuccess();
        }
    }

    public boolean isReferencedByCurrentObject(DataObject referencedObject, DataObject currentObject) {
        if (currentObject.getSuperClassName() != null && currentObject.getSuperClassName().equals(referencedObject.getClassName())) {
            return true;
        }
        if (currentObject.getProperties() != null) {
            for (ObjectProperty propertyTO : currentObject.getProperties()) {
                if (!propertyTO.getClassName().equals(referencedObject.getClassName())) continue;
                return true;
            }
        }
        return false;
    }
}

