/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.shared.event.ModalShownEvent;
import org.gwtbootstrap3.client.shared.event.ModalShownHandler;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.util.UIUtil;
import org.kie.workbench.common.screens.datamodeller.client.widgets.editor.NewFieldPopupView;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;

@Dependent
public class NewFieldPopupViewImpl
extends BaseModal
implements NewFieldPopupView {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    FormLabel newPropertyIdLabel;
    @UiField
    TextBox newPropertyId;
    @UiField
    FormLabel newPropertyLabelLabel;
    @UiField
    TextBox newPropertyLabel;
    @UiField
    FormLabel newPropertyTypeLabel;
    @UiField
    Select newPropertyTypeList;
    @UiField
    CheckBox isNewPropertyMultiple;
    @UiField
    Button createButton;
    @UiField
    Button createAndContinue;
    @UiField
    Button cancelButton;
    @UiField
    Alert messageHelpInline;
    private NewFieldPopupView.Presenter presenter;

    @Inject
    public NewFieldPopupViewImpl() {
    }

    @PostConstruct
    private void init() {
        this.setTitle(Constants.INSTANCE.objectBrowser_newFieldTitle());
        this.setBody((Widget)uiBinder.createAndBindUi(this));
        this.newPropertyTypeList.addValueChangeHandler(e -> this.presenter.onTypeChange());
        this.createButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewFieldPopupViewImpl.this.presenter.onCreate();
            }
        });
        this.createAndContinue.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewFieldPopupViewImpl.this.presenter.onCreateAndContinue();
            }
        });
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NewFieldPopupViewImpl.this.presenter.onCancel();
            }
        });
        this.addShownHandler(new ModalShownHandler(){

            public void onShown(ModalShownEvent shownEvent) {
                NewFieldPopupViewImpl.this.newPropertyId.setFocus(true);
            }
        });
        this.newPropertyId.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                NewFieldPopupViewImpl.this.clearErrorMessage();
            }
        });
    }

    public void init(NewFieldPopupView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void initTypeList(List<Pair<String, String>> options, boolean includeEmptyItem) {
        UIUtil.initList(this.newPropertyTypeList, options, includeEmptyItem);
    }

    @Override
    public String getSelectedType() {
        return this.newPropertyTypeList.getValue();
    }

    @Override
    public String getFieldName() {
        return this.newPropertyId.getText();
    }

    @Override
    public String getFieldLabel() {
        return this.newPropertyLabel.getText();
    }

    @Override
    public boolean getIsMultiple() {
        return this.isNewPropertyMultiple.getValue();
    }

    @Override
    public void setIsMultiple(boolean multiple) {
        this.isNewPropertyMultiple.setValue(Boolean.valueOf(multiple));
    }

    @Override
    public void enableIsMultiple(boolean enabled) {
        this.isNewPropertyMultiple.setEnabled(enabled);
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.messageHelpInline.setVisible(true);
        this.messageHelpInline.setText(errorMessage);
    }

    @Override
    public void setFocusOnFieldName() {
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                NewFieldPopupViewImpl.this.newPropertyId.setFocus(true);
            }
        });
    }

    @Override
    public void clear() {
        this.newPropertyId.setText(null);
        this.newPropertyLabel.setText(null);
        if (this.newPropertyTypeList.getValue() != null) {
            UIUtil.setSelectedValue(this.newPropertyTypeList, "NOT_SELECTED");
        }
        this.isNewPropertyMultiple.setValue(Boolean.valueOf(false));
        this.isNewPropertyMultiple.setEnabled(true);
        this.clearErrorMessage();
    }

    private void clearErrorMessage() {
        this.messageHelpInline.setText(null);
        this.messageHelpInline.setVisible(false);
    }

    static interface Binder
    extends UiBinder<Widget, NewFieldPopupViewImpl> {
    }
}

