/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain;

import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.AdvancedDataObjectFieldEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.FieldEditor;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ElementType;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;

@Dependent
public class AdvancedDataObjectFieldEditor
extends FieldEditor
implements AdvancedDataObjectFieldEditorView.Presenter {
    private AdvancedDataObjectFieldEditorView view;

    @Inject
    public AdvancedDataObjectFieldEditor(DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder, AdvancedDataObjectFieldEditorView view) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.view = view;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public String getName() {
        return "ADVANCED_FIELD_EDITOR";
    }

    @Override
    public String getDomainName() {
        return "ADVANCED";
    }

    @Override
    protected void loadDataObjectField(DataObject dataObject, ObjectProperty objectField) {
        this.clear();
        this.setReadonly(this.context != null ? this.context.isReadonly() : true);
        this.view.setReadonly(this.isReadonly());
        this.dataObject = dataObject;
        this.objectField = objectField;
        if (dataObject != null && objectField != null) {
            this.view.loadAnnotations(objectField.getAnnotations());
        }
    }

    @Override
    public void onDeleteAnnotation(Annotation annotation) {
        this.commandBuilder.buildFieldAnnotationRemoveCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), annotation.getClassName()).execute();
        this.view.removeAnnotation(annotation);
    }

    @Override
    public void onValuePairChange(String annotationClassName, String valuePair, Object newValue) {
        this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), annotationClassName, valuePair, newValue, false).execute();
        this.refresh();
    }

    @Override
    public void onClearValuePair(Annotation annotation, String valuePair) {
        this.commandBuilder.buildFieldAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), annotation.getClassName(), valuePair, null, false).execute();
        this.refresh();
    }

    @Override
    public void onAddAnnotation(Annotation annotation) {
        this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), this.getDataObject(), this.getObjectField(), annotation).execute();
        this.refresh();
    }

    @Override
    public void clear() {
        this.view.clear();
    }

    @Override
    public void onContextChange(DataModelerContext context) {
        this.view.init(context != null ? context.getCurrentProject() : null, ElementType.FIELD);
        this.view.setReadonly(context != null && context.isReadonly());
        super.onContextChange(context);
    }

    private void refresh() {
        this.loadDataObjectField(this.dataObject, this.objectField);
    }
}

