/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.packageselector;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.client.validation.ValidatorService;
import org.kie.workbench.common.screens.datamodeller.client.widgets.packageselector.NewPackagePopupView;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.mvp.Command;

@Dependent
public class NewPackagePopup
implements NewPackagePopupView.Presenter {
    private ValidatorService validatorService;
    private NewPackagePopupView view;
    private String packageName;
    private Command afterAddCommand;

    @Inject
    public NewPackagePopup(NewPackagePopupView view, ValidatorService validatorService) {
        this.view = view;
        view.init(this);
        this.validatorService = validatorService;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    private void clear() {
        this.packageName = null;
        this.view.setPackageName(null);
        this.view.clearErrors();
    }

    @Override
    public void onCreatePackage() {
        final String[] packageName = new String[]{this.toLowerCase(DataModelerUtils.trim(this.view.getPackageName()))};
        this.validatorService.isValidPackageIdentifier(packageName[0], new ValidatorCallback(){

            public void onFailure() {
                NewPackagePopup.this.view.setErrorMessage(Constants.INSTANCE.validation_error_invalid_package_identifier(packageName[0]));
            }

            public void onSuccess() {
                NewPackagePopup.this.setPackageName(packageName[0]);
                NewPackagePopup.this.view.hide();
                if (NewPackagePopup.this.afterAddCommand != null) {
                    NewPackagePopup.this.afterAddCommand.execute();
                }
            }
        });
    }

    @Override
    public void onValueTyped() {
        this.view.setPackageName(this.toLowerCase(this.view.getPackageName()));
    }

    public void show(Command afterAddCommand) {
        this.afterAddCommand = afterAddCommand;
        this.clear();
        this.view.show();
    }

    private String toLowerCase(String value) {
        return value != null ? value.toLowerCase() : null;
    }
}

