/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.command;

import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;

public class FieldAddOrRemoveAnnotationCommand
extends AbstractDataModelCommand {
    private boolean doAdd = true;
    private ObjectProperty field;

    public FieldAddOrRemoveAnnotationCommand(DataModelerContext context, String source, DataObject dataObject, ObjectProperty field, String annotationClassName, boolean doAdd, DataModelChangeNotifier notifier) {
        super(context, source, dataObject, notifier);
        this.field = field;
        this.setAnnotationClassName(annotationClassName);
        this.doAdd = doAdd;
    }

    @Override
    public void execute() {
        if (this.doAdd && this.field.getAnnotation(this.annotationClassName) == null) {
            this.field.addAnnotation((Annotation)new AnnotationImpl(this.context.getAnnotationDefinition(this.annotationClassName)));
            this.notifyFieldChange(ChangeType.FIELD_ANNOTATION_ADD_CHANGE, this.context, this.source, this.dataObject, this.field, this.annotationClassName, null, null, null);
        } else if (!this.doAdd && this.field.getAnnotation(this.annotationClassName) != null) {
            this.field.removeAnnotation(this.annotationClassName);
            this.notifyFieldChange(ChangeType.FIELD_ANNOTATION_REMOVE_CHANGE, this.context, this.source, this.dataObject, this.field, this.annotationClassName, null, null, null);
        }
    }
}

