/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.validation;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datamodeller.validation.PersistenceDescriptorValidationMessage;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationMessageTranslator;

@ApplicationScoped
public class PersistenceDescriptorValidationMessageTranslator
implements ValidationMessageTranslator {
    public static final String PREFIX = "persistence_descriptor_validation_";
    private TranslationService translationService;

    @Inject
    public PersistenceDescriptorValidationMessageTranslator(TranslationService translationService) {
        this.translationService = translationService;
    }

    public boolean accept(ValidationMessage checkMessage) {
        return checkMessage instanceof PersistenceDescriptorValidationMessage;
    }

    public ValidationMessage translate(ValidationMessage checkMessage) {
        PersistenceDescriptorValidationMessage pdValidationMessage = (PersistenceDescriptorValidationMessage)checkMessage;
        ValidationMessage result = new ValidationMessage();
        result.setId(checkMessage.getId());
        result.setLevel(checkMessage.getLevel());
        String translationKey = this.createTranslationKey(pdValidationMessage.getId());
        if (this.translationService.getTranslation(translationKey) != null) {
            if (pdValidationMessage.getParams() != null && !pdValidationMessage.getParams().isEmpty()) {
                pdValidationMessage.getParams().toArray(new String[pdValidationMessage.getParams().size()]);
                result.setText(this.translationService.format(translationKey, pdValidationMessage.getParams().toArray()));
            } else {
                result.setText(this.translationService.getTranslation(translationKey));
            }
        } else {
            result.setText(checkMessage.getText());
        }
        return result;
    }

    private String createTranslationKey(long id) {
        return PREFIX + id;
    }
}

