/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.numeric;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.ValuePairEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.ValuePairEditorHandler;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.numeric.NumericValuePairEditorView;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.numeric.NumericValuePairEditorViewImpl;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.util.NumberType;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.util.ValuePairEditorUtil;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;

public class NumericValuePairEditor
implements NumericValuePairEditorView.Presenter,
ValuePairEditor<Object> {
    private NumericValuePairEditorView view;
    private Object currentValue = null;
    private NumberType numberType = NumberType.INT;
    private AnnotationValuePairDefinition valuePairDefinition;
    private ValuePairEditorHandler editorHandler;
    boolean valid = true;

    public NumericValuePairEditor() {
        this((NumericValuePairEditorView)GWT.create(NumericValuePairEditorViewImpl.class));
    }

    public NumericValuePairEditor(NumericValuePairEditorView view) {
        this.view = view;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void init(AnnotationValuePairDefinition valuePairDefinition) {
        this.valuePairDefinition = valuePairDefinition;
        this.numberType = ValuePairEditorUtil.getNumberType(valuePairDefinition);
        this.view.setValuePairLabel(ValuePairEditorUtil.buildValuePairLabel(valuePairDefinition));
        this.view.showValuePairRequiredIndicator(!valuePairDefinition.hasDefaultValue());
    }

    public NumberType getNumberType() {
        return this.numberType;
    }

    @Override
    public Object getValue() {
        return this.currentValue;
    }

    @Override
    public void setValue(Object value) {
        this.currentValue = value;
        this.view.setValue(value != null ? value.toString() : null);
        this.valid = true;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void onValueChange() {
        String value = this.view.getValue();
        if ("".equals(this.view.getValue()) || this.view.getValue() == null) {
            this.currentValue = null;
            this.valid = true;
            this.view.clearErrorMessage();
        } else {
            String errorMessage = null;
            try {
                this.currentValue = ValuePairEditorUtil.parseNumberValue(value, this.numberType);
                this.valid = true;
            }
            catch (Exception e) {
                errorMessage = e.getMessage();
                this.currentValue = null;
                this.valid = false;
            }
            if (this.valid) {
                this.view.clearErrorMessage();
            } else {
                this.view.setErrorMessage(errorMessage);
            }
        }
        if (this.editorHandler != null) {
            this.editorHandler.onValueChange();
        }
    }

    @Override
    public void clear() {
        this.view.clear();
        this.setValue((Object)null);
    }

    @Override
    public void addEditorHandler(ValuePairEditorHandler editorHandler) {
        this.editorHandler = editorHandler;
    }

    @Override
    public AnnotationValuePairDefinition getValuePairDefinition() {
        return this.valuePairDefinition;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.view.setErrorMessage(errorMessage);
    }

    @Override
    public void clearErrorMessage() {
        this.view.clearErrorMessage();
    }

    @Override
    public void showValidateButton(boolean show) {
    }

    @Override
    public void showValuePairName(boolean show) {
        this.view.showValuePairName(show);
    }

    @Override
    public void refresh() {
    }
}

