/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.util;

import com.google.gwt.regexp.shared.RegExp;
import org.kie.workbench.common.screens.datamodeller.client.widgets.advanceddomain.valuepaireditor.util.NumberType;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;

public class ValuePairEditorUtil {
    private static final RegExp hexaCharsExp = RegExp.compile((String)"[0-9a-fA-F]");

    public static String buildValuePairLabel(AnnotationValuePairDefinition valuePairDefinition) {
        return valuePairDefinition.getName();
    }

    public static boolean validate(String value, NumberType numberType) {
        try {
            ValuePairEditorUtil.parseNumberValue(value, numberType);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static NumberType getNumberType(AnnotationValuePairDefinition valuePairDefinition) {
        String clazz = valuePairDefinition.getClassName();
        if (valuePairDefinition.isPrimitiveType()) {
            if ("byte".equals(clazz) || Byte.class.getName().equals(clazz)) {
                return NumberType.BYTE;
            }
            if ("short".equals(clazz) || Short.class.getName().equals(clazz)) {
                return NumberType.SHORT;
            }
            if ("int".equals(clazz) || Integer.class.getName().equals(clazz)) {
                return NumberType.INT;
            }
            if ("long".equals(clazz) || Long.class.getName().equals(clazz)) {
                return NumberType.LONG;
            }
            if ("float".equals(clazz) || Float.class.getName().equals(clazz)) {
                return NumberType.FLOAT;
            }
            if ("double".equals(clazz) || Double.class.getName().equals(clazz)) {
                return NumberType.DOUBLE;
            }
        }
        return null;
    }

    public static boolean isNumberType(AnnotationValuePairDefinition valuePairDefinition) {
        return ValuePairEditorUtil.getNumberType(valuePairDefinition) != null;
    }

    public static Object parseNumberValue(String value, NumberType numberType) throws NumberFormatException {
        try {
            switch (numberType) {
                case BYTE: {
                    return Byte.parseByte(value);
                }
                case SHORT: {
                    return Short.parseShort(value);
                }
                case INT: {
                    return Integer.parseInt(value);
                }
                case LONG: {
                    return Long.parseLong(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
            }
        }
        catch (Exception e) {
            throw new NumberFormatException("Invalid " + (Object)((Object)numberType) + " value.");
        }
        throw new NumberFormatException("Unknown NumberType: " + (Object)((Object)numberType));
    }

    public static boolean isValidCharacterLiteral(String charLiteralStr) {
        if (charLiteralStr == null || charLiteralStr.length() == 0) {
            return false;
        }
        if (charLiteralStr.length() == 1 && charLiteralStr.charAt(0) == ' ') {
            return true;
        }
        if ((charLiteralStr = charLiteralStr.trim()).length() == 0) {
            return false;
        }
        if (charLiteralStr.length() == 1 && charLiteralStr.charAt(0) != '\\' && charLiteralStr.charAt(0) != '\"' && charLiteralStr.charAt(0) != '\'') {
            return true;
        }
        if (charLiteralStr.length() == 2 && charLiteralStr.charAt(0) == '\\' && (charLiteralStr.charAt(1) == 't' || charLiteralStr.charAt(1) == 'b' || charLiteralStr.charAt(1) == 'n' || charLiteralStr.charAt(1) == 'r' || charLiteralStr.charAt(1) == 'f' || charLiteralStr.charAt(1) == '\'' || charLiteralStr.charAt(1) == '\"' || charLiteralStr.charAt(1) == '\\')) {
            return true;
        }
        return charLiteralStr.length() == 6 && charLiteralStr.charAt(0) == '\\' && charLiteralStr.charAt(1) == 'u' && ValuePairEditorUtil.hasValidHexaDecimalChars(charLiteralStr, 2);
    }

    public static String unquoteCharacterLiteral(String charLiteralStr) {
        if (charLiteralStr != null && charLiteralStr.length() >= 3 && charLiteralStr.charAt(0) == '\'' && charLiteralStr.charAt(charLiteralStr.length() - 1) == '\'') {
            return charLiteralStr.substring(1, charLiteralStr.length() - 1);
        }
        return charLiteralStr;
    }

    public static boolean hasValidHexaDecimalChars(String charLiteralStr, int start) {
        for (int i = start + 1; i < charLiteralStr.length(); ++i) {
            if (ValuePairEditorUtil.isValidHexaDecimalChar(charLiteralStr.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidHexaDecimalChar(char hexaDecimalChar) {
        return hexaCharsExp.test(new String(new char[]{hexaDecimalChar}));
    }

    public static boolean isBlankCharaterSequence(String charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        for (int i = 0; i < charSequence.length(); ++i) {
            if (' ' == charSequence.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

