/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.docks;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datamodeller.client.DataModelerContext;
import org.kie.workbench.common.screens.datamodeller.client.context.DataModelerWorkbenchContext;
import org.kie.workbench.common.screens.datamodeller.client.context.DataModelerWorkbenchContextChangeEvent;
import org.kie.workbench.common.screens.datamodeller.client.context.DataModelerWorkbenchFocusEvent;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.resources.images.ImagesResources;
import org.kie.workbench.common.widgets.client.docks.AbstractWorkbenchDocksHandler;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.authz.AuthorizationManager;

@Dependent
public class DataModellerDocksHandler
extends AbstractWorkbenchDocksHandler {
    protected Constants constants = Constants.INSTANCE;
    protected SessionInfo sessionInfo;
    protected AuthorizationManager authorizationManager;
    protected DataModelerWorkbenchContext dataModelerWBContext;
    protected DataModelerContext lastActiveContext;
    protected DataModelerContext.EditionMode lastEditionMode;
    protected boolean dataModelerIsHidden;

    @Inject
    public DataModellerDocksHandler(SessionInfo sessionInfo, AuthorizationManager authorizationManager, DataModelerWorkbenchContext dataModelerWBContext) {
        this.sessionInfo = sessionInfo;
        this.authorizationManager = authorizationManager;
        this.dataModelerWBContext = dataModelerWBContext;
    }

    public boolean isGraphicMode(DataModelerContext context) {
        return context != null && context.getEditionMode().equals((Object)DataModelerContext.EditionMode.GRAPHICAL_MODE);
    }

    public Collection<UberfireDock> provideDocks(String perspectiveIdentifier) {
        ArrayList<UberfireDock> result = new ArrayList<UberfireDock>();
        if (this.lastActiveContext == null) {
            this.lastActiveContext = this.dataModelerWBContext.getActiveContext();
        }
        if (this.isGraphicMode(this.lastActiveContext)) {
            result.add(new UberfireDock(UberfireDockPosition.EAST, "RANDOM", (PlaceRequest)new DefaultPlaceRequest("DroolsDomainScreen"), perspectiveIdentifier).withSize(450.0).withLabel(this.constants.DocksDroolsJBPMTitle()));
            result.add(new UberfireDock(UberfireDockPosition.EAST, "BRIEFCASE", (PlaceRequest)new DefaultPlaceRequest("JPADomainScreen"), perspectiveIdentifier).withSize(450.0).withLabel(this.constants.DocksPersistenceTitle()));
            result.add(new UberfireDock(UberfireDockPosition.EAST, "COG", (PlaceRequest)new DefaultPlaceRequest("AdvancedDomainScreen"), perspectiveIdentifier).withSize(450.0).withLabel(this.constants.DocksAdvancedTitle()));
            if (this.authorizationManager.authorize("planner.available", this.sessionInfo.getIdentity())) {
                result.add(new UberfireDock(UberfireDockPosition.EAST, ImagesResources.INSTANCE.optaPlannerDisabledIcon(), ImagesResources.INSTANCE.optaPlannerEnabledIcon(), (PlaceRequest)new DefaultPlaceRequest("PlannerDomainScreen"), perspectiveIdentifier).withSize(450.0).withLabel(this.constants.DocksOptaPlannerTitle()));
            }
        }
        return result;
    }

    public void onContextChange(@Observes DataModelerWorkbenchContextChangeEvent contextEvent) {
        boolean doRefresh;
        DataModelerContext newContext = this.dataModelerWBContext.getActiveContext();
        if (newContext == null) {
            doRefresh = true;
            this.dataModelerIsHidden = true;
        } else if (!newContext.equals(this.lastActiveContext) || newContext.equals(this.lastActiveContext) && !newContext.getEditionMode().equals((Object)this.lastEditionMode)) {
            doRefresh = true;
            this.dataModelerIsHidden = !this.isGraphicMode(newContext);
            this.lastEditionMode = newContext.getEditionMode();
        } else {
            doRefresh = false;
        }
        this.lastActiveContext = newContext;
        this.refreshDocks(doRefresh, this.dataModelerIsHidden);
    }

    public void onDataModelerWorkbenchFocusEvent(@Observes DataModelerWorkbenchFocusEvent event) {
        this.dataModelerIsHidden = !event.isFocused();
        this.refreshDocks(true, this.dataModelerIsHidden);
    }
}

