/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain.command;

import java.util.ArrayList;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelChangeNotifier;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.command.ValuePair;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.CascadeType;
import org.kie.workbench.common.screens.datamodeller.model.jpadomain.FetchMode;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;

public class AdjustFieldDefaultRelationsCommand
extends AbstractDataModelCommand {
    protected ObjectProperty field;
    protected AbstractDataModelCommand previousCommand;
    DataModelCommandBuilder commandBuilder;

    public AdjustFieldDefaultRelationsCommand(AbstractDataModelCommand previousCommand, String source, ObjectProperty field, DataModelChangeNotifier notifier, DataModelCommandBuilder commandBuilder) {
        super(previousCommand.getContext(), source, previousCommand.getDataObject(), notifier);
        this.previousCommand = previousCommand;
        this.field = field;
        this.commandBuilder = commandBuilder;
    }

    public ObjectProperty getField() {
        return this.field;
    }

    public void setField(ObjectProperty field) {
        this.field = field;
    }

    public AbstractDataModelCommand getPreviousCommand() {
        return this.previousCommand;
    }

    public void setPreviousCommand(AbstractDataModelCommand previousCommand) {
        this.previousCommand = previousCommand;
    }

    @Override
    public void execute() {
        ArrayList<String> defaultCascadeType = new ArrayList<String>(1);
        defaultCascadeType.add(CascadeType.ALL.name());
        String defaultFetchMode = FetchMode.EAGER.name();
        if (this.getContext().getHelper().isPrimitiveType(this.field.getClassName()).booleanValue()) {
            this.removeOneToOne();
            this.removeOneTMany();
            this.removeManyToOne();
            this.removeElementCollection();
        } else if (this.getContext().getHelper().isBaseType(this.field.getClassName()).booleanValue() || this.getContext().getDataModel().isEnum(this.field.getClassName())) {
            this.removeOneToOne();
            this.removeOneTMany();
            this.removeManyToOne();
            if (this.field.isMultiple()) {
                if (this.field.getAnnotation("javax.persistence.ElementCollection") == null) {
                    ArrayList<ValuePair> values = new ArrayList<ValuePair>();
                    values.add(new ValuePair("fetch", defaultFetchMode));
                    this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.source, this.getDataObject(), this.field, "javax.persistence.ElementCollection", values).execute();
                }
            } else {
                this.removeElementCollection();
            }
        } else {
            this.removeOneToOne();
            this.removeElementCollection();
            if (this.field.isMultiple()) {
                this.removeManyToOne();
                if (this.field.getAnnotation("javax.persistence.OneToMany") == null) {
                    this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.source, this.getDataObject(), this.getField(), "javax.persistence.OneToMany").withValuePair("cascade", defaultCascadeType).withValuePair("fetch", defaultFetchMode).execute();
                }
            } else {
                this.removeOneTMany();
                if (this.field.getAnnotation("javax.persistence.ManyToOne") == null) {
                    this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.source, this.getDataObject(), this.getField(), "javax.persistence.ManyToOne").withValuePair("cascade", defaultCascadeType).withValuePair("fetch", defaultFetchMode).execute();
                }
            }
        }
    }

    private void removeManyToOne() {
        this.commandBuilder.buildFieldAnnotationRemoveCommand(this.getContext(), this.source, this.getDataObject(), this.getField(), "javax.persistence.ManyToOne").execute();
    }

    private void removeOneTMany() {
        this.commandBuilder.buildFieldAnnotationRemoveCommand(this.getContext(), this.source, this.getDataObject(), this.getField(), "javax.persistence.OneToMany").execute();
    }

    private void removeElementCollection() {
        this.commandBuilder.buildFieldAnnotationRemoveCommand(this.getContext(), this.source, this.getDataObject(), this.getField(), "javax.persistence.ElementCollection").execute();
    }

    private void removeOneToOne() {
        this.commandBuilder.buildFieldAnnotationRemoveCommand(this.getContext(), this.source, this.getDataObject(), this.getField(), "javax.persistence.OneToOne").execute();
    }
}

