/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.kie.workbench.common.screens.datamodeller.client.command.AbstractDataModelCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataModelCommandBuilder;
import org.kie.workbench.common.screens.datamodeller.client.command.DataObjectAddOrRemoveAnnotationCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.DataObjectAnnotationValueChangeCommand;
import org.kie.workbench.common.screens.datamodeller.client.command.ValuePair;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandlerRegistry;
import org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain.JPADomainHandler;
import org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain.util.SequenceGeneratorValueHandler;
import org.kie.workbench.common.screens.datamodeller.client.model.DataModelerPropertyEditorFieldInfo;
import org.kie.workbench.common.screens.datamodeller.client.resources.i18n.Constants;
import org.kie.workbench.common.screens.datamodeller.client.util.AnnotationValueHandler;
import org.kie.workbench.common.screens.datamodeller.client.util.DataModelerUtils;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ObjectEditor;
import org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.JPADataObjectEditorView;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerEvent;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;
import org.uberfire.ext.properties.editor.client.fields.BooleanField;
import org.uberfire.ext.properties.editor.client.fields.TextField;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;

@Dependent
public class JPADataObjectEditor
extends ObjectEditor
implements JPADataObjectEditorView.Presenter {
    private static Map<String, DataModelerPropertyEditorFieldInfo> propertyEditorFields = new HashMap<String, DataModelerPropertyEditorFieldInfo>();
    private JPADataObjectEditorView view;
    private JPADomainHandler handler;
    private static final String EOL = "</BR>";
    private static final String BLANK = "&nbsp;";
    private static final String TWO_BLANKS = "&nbsp;&nbsp;";

    @Inject
    public JPADataObjectEditor(JPADataObjectEditorView view, DomainHandlerRegistry handlerRegistry, Event<DataModelerEvent> dataModelerEvent, DataModelCommandBuilder commandBuilder) {
        super(handlerRegistry, dataModelerEvent, commandBuilder);
        this.view = view;
        view.init(this);
        ArrayList<String> domainQuery = new ArrayList<String>();
        domainQuery.add(this.getDomainName());
        this.handler = (JPADomainHandler)handlerRegistry.getDomainHandlers(domainQuery).get(0);
    }

    @PostConstruct
    protected void init() {
        this.loadPropertyEditor();
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public String getName() {
        return "JPA_OBJECT_EDITOR";
    }

    @Override
    public String getDomainName() {
        return "JPA";
    }

    @Override
    protected void loadDataObject(DataObject dataObject) {
        this.clear();
        this.setReadonly(true);
        this.dataObject = dataObject;
        if (dataObject != null) {
            this.updateEntityField(dataObject.getAnnotation("javax.persistence.Entity"));
            this.updateTableNameField(dataObject.getAnnotation("javax.persistence.Table"));
            this.updateAuditedField(dataObject.getAnnotation("org.hibernate.envers.Audited"));
            this.setReadonly(this.getContext() == null || this.getContext().isReadonly());
        }
        this.loadPropertyEditor();
    }

    @Override
    public void onEntityFieldChange(String newValue) {
        if (this.getDataObject() != null) {
            Boolean doAdd = Boolean.parseBoolean(newValue);
            if (doAdd.booleanValue()) {
                if (!this.hasIdField(this.getDataObject())) {
                    List<ObjectProperty> configurableFields = this.persistenceConfigurableFields(this.getDataObject());
                    String message = this.buildOnSetPersistableRefactoringMessage(false, configurableFields);
                    this.view.showYesNoCancelPopup(CommonConstants.INSTANCE.Warning(), message, () -> this.doEntityFieldChange(doAdd, true), Constants.INSTANCE.persistence_domain_objectEditor_add_identifier_action(), ButtonType.PRIMARY, () -> this.doEntityFieldChange(doAdd, false), Constants.INSTANCE.persistence_domain_objectEditor_dont_add_identifier_action(), ButtonType.DANGER, () -> {
                        this.updateEntityField(null);
                        this.loadPropertyEditor();
                    }, CommonConstants.INSTANCE.Cancel(), ButtonType.DEFAULT);
                } else {
                    this.doEntityFieldChange(doAdd, false);
                }
            } else {
                this.doEntityFieldChange(doAdd, false);
            }
        }
    }

    @Override
    public void onTableNameChange(String newValue) {
        if (this.getDataObject() != null) {
            String value = DataModelerUtils.nullTrim(newValue);
            DataObjectAnnotationValueChangeCommand command = this.commandBuilder.buildDataObjectAnnotationValueChangeCommand(this.getContext(), this.getName(), this.getDataObject(), "javax.persistence.Table", "name", value, true);
            command.execute();
        }
    }

    @Override
    public void onAuditedFieldChange(String newValue) {
        if (this.getDataObject() != null) {
            AbstractDataModelCommand command;
            Boolean doAdd = Boolean.parseBoolean(newValue);
            if (doAdd.booleanValue()) {
                ArrayList<ValuePair> defaultValues = new ArrayList<ValuePair>();
                defaultValues.add(new ValuePair("targetAuditMode", "NOT_AUDITED"));
                command = this.commandBuilder.buildDataObjectAddAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.hibernate.envers.Audited", defaultValues);
            } else {
                command = this.commandBuilder.buildDataObjectRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "org.hibernate.envers.Audited");
            }
            command.execute();
        }
    }

    protected void doEntityFieldChange(boolean isPersistable, boolean generateIdenfitier) {
        DataObjectAddOrRemoveAnnotationCommand command = this.commandBuilder.buildDataObjectAddOrRemoveAnnotationCommand(this.getContext(), this.getName(), this.getDataObject(), "javax.persistence.Entity", isPersistable);
        if (generateIdenfitier) {
            this.addByDefaultId(this.dataObject);
        }
        command.execute();
    }

    private void updateEntityField(Annotation annotation) {
        this.clearEntityField();
        if (annotation != null) {
            this.updatePropertyEditorField("ENTITY_FIELD", annotation, "true");
        }
    }

    private void updateTableNameField(Annotation annotation) {
        this.clearTableNameField();
        if (annotation != null) {
            String tableName = AnnotationValueHandler.getStringValue(annotation, "name", null);
            this.updatePropertyEditorField("TABLE_NAME_FIELD", annotation, tableName);
        }
    }

    private void updateAuditedField(Annotation annotation) {
        this.clearAuditedField();
        if (annotation != null && propertyEditorFields.containsKey("AUDITED_FIELD")) {
            this.updatePropertyEditorField("AUDITED_FIELD", annotation, "true");
        }
    }

    protected void loadPropertyEditor() {
        this.view.loadPropertyEditorCategories(this.getPropertyEditorCategories());
    }

    protected List<PropertyEditorCategory> getPropertyEditorCategories() {
        ArrayList<PropertyEditorCategory> categories = new ArrayList<PropertyEditorCategory>();
        PropertyEditorCategory category = new PropertyEditorCategory(this.getEntityCategoryName(), 1);
        categories.add(category);
        category.withField((PropertyEditorFieldInfo)this.createEntityField());
        category.withField((PropertyEditorFieldInfo)this.createTableNameField());
        if (this.handler.isDataObjectAuditEnabled()) {
            category.withField((PropertyEditorFieldInfo)this.createAuditedField());
        }
        return categories;
    }

    private DataModelerPropertyEditorFieldInfo createEntityField() {
        return this.createField(Constants.INSTANCE.persistence_domain_objectEditor_entity_field_label(), "ENTITY_FIELD", "false", BooleanField.class, Constants.INSTANCE.persistence_domain_objectEditor_entity_field_help_heading(), Constants.INSTANCE.persistence_domain_objectEditor_entity_field_help(), this.readonly);
    }

    private DataModelerPropertyEditorFieldInfo createTableNameField() {
        return this.createField(Constants.INSTANCE.persistence_domain_objectEditor_table_field_label(), "TABLE_NAME_FIELD", "", TextField.class, Constants.INSTANCE.persistence_domain_objectEditor_table_field_help_heading(), Constants.INSTANCE.persistence_domain_objectEditor_table_field_help(), this.readonly);
    }

    private DataModelerPropertyEditorFieldInfo createAuditedField() {
        return this.createField(Constants.INSTANCE.persistence_domain_objectEditor_audited_field_label(), "AUDITED_FIELD", "false", BooleanField.class, Constants.INSTANCE.persistence_domain_objectEditor_audited_field_help_heading(), Constants.INSTANCE.persistence_domain_objectEditor_audited_field_help(), this.readonly);
    }

    private DataModelerPropertyEditorFieldInfo createField(String label, String key, String currentStringValue, Class<?> customFieldClass, String helpHeading, String helpText, boolean readonly) {
        DataModelerPropertyEditorFieldInfo fieldInfo = propertyEditorFields.get(key);
        if (fieldInfo == null) {
            fieldInfo = new DataModelerPropertyEditorFieldInfo(label, currentStringValue, customFieldClass);
            fieldInfo.withKey(key);
            if (helpHeading != null) {
                fieldInfo.withHelpInfo(helpHeading, helpText);
            }
            propertyEditorFields.put(key, fieldInfo);
        }
        fieldInfo.setDisabled(readonly);
        return fieldInfo;
    }

    @Override
    public void clear() {
        this.clearEntityField();
        this.clearTableNameField();
        this.clearAuditedField();
    }

    private void clearEntityField() {
        this.updatePropertyEditorField("ENTITY_FIELD", null, "false");
    }

    private void clearTableNameField() {
        this.updatePropertyEditorField("TABLE_NAME_FIELD", null, "");
    }

    private void clearAuditedField() {
        if (propertyEditorFields.containsKey("AUDITED_FIELD")) {
            this.updatePropertyEditorField("AUDITED_FIELD", null, "false");
        }
    }

    private void updatePropertyEditorField(String fieldId, Annotation currentValue, String currentStringValue) {
        DataModelerPropertyEditorFieldInfo fieldInfo = propertyEditorFields.get(fieldId);
        fieldInfo.setCurrentValue(currentValue);
        fieldInfo.setCurrentStringValue(currentStringValue);
    }

    private String getEntityCategoryName() {
        return Constants.INSTANCE.persistence_domain_objectEditor_entity_category();
    }

    private boolean hasIdField(DataObject dataObject) {
        for (ObjectProperty objectProperty : dataObject.getProperties()) {
            if (objectProperty.getAnnotation("javax.persistence.Id") == null) continue;
            return true;
        }
        return false;
    }

    private List<ObjectProperty> persistenceConfigurableFields(DataObject dataObject) {
        ArrayList<ObjectProperty> result = new ArrayList<ObjectProperty>();
        for (ObjectProperty field : dataObject.getProperties()) {
            if (!DataModelerUtils.isManagedProperty(field) || !field.isMultiple() && field.isBaseType()) continue;
            result.add(field);
        }
        return result;
    }

    private void addByDefaultId(DataObject dataObject) {
        String idFieldName = this.generateIdFieldName(dataObject);
        this.commandBuilder.buildAddPropertyCommand(this.getContext(), this.getName(), dataObject, idFieldName, null, Long.class.getName(), false).execute();
        ObjectProperty idField = dataObject.getProperty(idFieldName);
        this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), dataObject, idField, "javax.persistence.Id").execute();
        String generatorName = dataObject.getName().toUpperCase() + "_ID_GENERATOR";
        AnnotationImpl generatedValue = new AnnotationImpl(this.context.getAnnotationDefinition("javax.persistence.GeneratedValue"));
        generatedValue.setValue("generator", (Object)generatorName);
        generatedValue.setValue("strategy", (Object)"AUTO");
        this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), dataObject, idField, (Annotation)generatedValue).execute();
        String sequenceName = dataObject.getName().toUpperCase() + "_ID_SEQ";
        Annotation sequenceGenerator = SequenceGeneratorValueHandler.createAnnotation(generatorName, sequenceName, this.context.getAnnotationDefinitions());
        this.commandBuilder.buildFieldAnnotationAddCommand(this.getContext(), this.getName(), dataObject, idField, sequenceGenerator).execute();
    }

    private String generateIdFieldName(DataObject dataObject) {
        String id = "id";
        int i = 1;
        boolean generated = false;
        while (!generated) {
            if (dataObject.getProperty(id) == null) {
                generated = true;
                continue;
            }
            id = "id" + i;
            ++i;
        }
        return id;
    }

    private String buildOnSetPersistableRefactoringMessage(boolean hasIdentifier, List<ObjectProperty> configurableFields) {
        StringBuilder message = new StringBuilder();
        message.append(Constants.INSTANCE.persistence_domain_objectEditor_on_make_persistable_message());
        message.append(EOL);
        if (!hasIdentifier) {
            message.append(Constants.INSTANCE.persistence_domain_objectEditor_required_identifier_is_missing_message());
        }
        if (configurableFields.size() > 0) {
            message.append(Constants.INSTANCE.persistence_domain_objectEditor_review_relationship_fields_message());
            message.append(TWO_BLANKS);
            boolean isFirst = true;
            for (ObjectProperty field : configurableFields) {
                if (!isFirst) {
                    message.append(",&nbsp;&nbsp;");
                }
                isFirst = false;
                message.append(Constants.INSTANCE.persistence_domain_objectEditor_review_relationship_field_for_review_message(field.getName()));
            }
        }
        return message.toString();
    }
}

