/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.client.widgets.jpadomain.options;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.kie.workbench.common.screens.datamodeller.client.handlers.DomainHandler;
import org.kie.workbench.common.screens.datamodeller.client.handlers.jpadomain.JPADomainHandler;
import org.kie.workbench.common.screens.datamodeller.client.widgets.common.domain.ResourceOptions;
import org.uberfire.client.views.pfly.widgets.HelpIcon;

@Dependent
public class JPANewResourceOptions
extends Composite
implements ResourceOptions {
    private static JPANewResourceOptionsUIBinder uiBinder = (JPANewResourceOptionsUIBinder)GWT.create(JPANewResourceOptionsUIBinder.class);
    @UiField
    CheckBox persistable;
    @UiField
    CheckBox audited;
    @UiField
    HelpIcon auditedHelpIcon;
    @Inject
    private JPADomainHandler handler;

    public JPANewResourceOptions() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.setAuditOptionsVisible(false);
        this.persistable.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                JPANewResourceOptions.this.onPersistableChanged();
            }
        });
    }

    public boolean isPersitable() {
        return this.persistable.getValue();
    }

    public void setPersistable(boolean persistable) {
        this.persistable.setValue(Boolean.valueOf(persistable));
    }

    public boolean getAudited() {
        return this.audited.getValue();
    }

    public void setAudited(boolean audited) {
        this.audited.setValue(Boolean.valueOf(audited));
    }

    @Override
    public void restoreOptionsDefaults() {
        this.setPersistable(false);
        this.setAudited(false);
        this.setAuditOptionsVisible(false);
    }

    @Override
    public Map<String, Object> getOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("persistable", this.isPersitable());
        if (this.isPersitable() && this.handler.isDataObjectAuditEnabled()) {
            options.put("audited", this.getAudited());
        }
        return options;
    }

    @Override
    public DomainHandler getHandler() {
        return this.handler;
    }

    @Override
    public Widget getWidget() {
        return super.asWidget();
    }

    private void onPersistableChanged() {
        if (this.isPersitable() && this.handler.isDataObjectAuditEnabled()) {
            this.setAuditOptionsVisible(true);
        } else {
            this.setAudited(false);
            this.setAuditOptionsVisible(false);
        }
    }

    private void setAuditOptionsVisible(boolean visible) {
        this.audited.setVisible(visible);
        this.auditedHelpIcon.setVisible(visible);
    }

    static interface JPANewResourceOptionsUIBinder
    extends UiBinder<Widget, JPANewResourceOptions> {
    }
}

