/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.editor.datasource;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.DataSourceDefEditorHelper;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.DataSourceDefEditorView;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.DataSourceDefMainPanel;
import org.kie.workbench.common.screens.datasource.management.client.type.DataSourceDefType;
import org.kie.workbench.common.screens.datasource.management.client.util.PopupsUtil;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDefEditorContent;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.model.TestResult;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceDefEditorService;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceRuntimeManagerClientService;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.file.popups.DeletePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="DataSourceDefEditor", supportedTypes={DataSourceDefType.class})
public class DataSourceDefEditor
extends BaseEditor
implements DataSourceDefEditorView.Presenter {
    private DataSourceDefEditorView view;
    private DataSourceDefMainPanel mainPanel;
    private DataSourceDefEditorHelper editorHelper;
    private PopupsUtil popupsUtil;
    private DataSourceDefType type;
    private Caller<DataSourceDefEditorService> editorService;
    private Caller<DataSourceRuntimeManagerClientService> dataSourceManagerClient;
    private DataSourceDefEditorContent editorContent;
    private SavePopUpPresenter savePopUpPresenter;
    private DeletePopUpPresenter deletePopUpPresenter;

    @Inject
    public DataSourceDefEditor(DataSourceDefEditorView view, DataSourceDefMainPanel mainPanel, DataSourceDefEditorHelper editorHelper, PopupsUtil popupsUtil, DataSourceDefType type, SavePopUpPresenter savePopUpPresenter, DeletePopUpPresenter deletePopUpPresenter, Caller<DataSourceDefEditorService> editorService, Caller<DataSourceRuntimeManagerClientService> dataSourceManagerClient) {
        super((BaseEditorView)view);
        this.view = view;
        this.mainPanel = mainPanel;
        this.editorHelper = editorHelper;
        this.popupsUtil = popupsUtil;
        this.type = type;
        this.savePopUpPresenter = savePopUpPresenter;
        this.deletePopUpPresenter = deletePopUpPresenter;
        this.editorService = editorService;
        this.dataSourceManagerClient = dataSourceManagerClient;
        view.init(this);
        view.setMainPanel(mainPanel);
        editorHelper.init(mainPanel);
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.init(path, place, this.type, true, false, new MenuItems[]{MenuItems.SAVE});
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.view.asWidget();
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose(Integer.valueOf(this.getContent().hashCode()));
    }

    protected void loadContent() {
        ((DataSourceDefEditorService)this.editorService.call(this.getLoadContentSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    public boolean mayClose(Integer currentHash) {
        return super.mayClose(currentHash);
    }

    protected void makeMenuBar() {
        super.makeMenuBar();
        this.menuBuilder.addDelete(this.onDelete(this.versionRecordManager.getCurrentPath()));
        this.menuBuilder.addValidate(this.onValidate());
        this.addTestMenu();
    }

    protected void save() {
        if (!(this.editorHelper.isNameValid() && this.editorHelper.isConnectionURLValid() && this.editorHelper.isUserValid() && this.editorHelper.isPasswordValid() && this.editorHelper.isDriverValid())) {
            this.popupsUtil.showInformationPopup(this.editorHelper.getMessage("DataSourceDefEditor.AllFieldsRequiresValidation"));
        } else {
            this.safeSave();
        }
    }

    protected void safeSave() {
        this.executeSafeUpdateCommand("DataSourceDefEditor.DataSourceHasBeenReferencedForSaveMessage", new Command(){

            public void execute() {
                DataSourceDefEditor.this._save();
            }
        }, new Command(){

            public void execute() {
                DataSourceDefEditor.this._save();
            }
        }, new Command(){

            public void execute() {
            }
        });
    }

    protected void _save() {
        this.savePopUpPresenter.show((Path)this.versionRecordManager.getCurrentPath(), (ParameterizedCommand)new ParameterizedCommand<String>(){

            public void execute(String commitMessage) {
                ((DataSourceDefEditorService)DataSourceDefEditor.this.editorService.call(DataSourceDefEditor.this.getSaveSuccessCallback(DataSourceDefEditor.this.getContent().hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)DataSourceDefEditor.this.view))).save((Path)DataSourceDefEditor.this.versionRecordManager.getCurrentPath(), DataSourceDefEditor.this.getContent(), commitMessage);
            }
        });
        this.concurrentUpdateSessionInfo = null;
    }

    protected Command onDelete(final ObservablePath currentPath) {
        return new Command(){

            public void execute() {
                DataSourceDefEditor.this.safeDelete(currentPath);
            }
        };
    }

    protected void safeDelete(final ObservablePath currentPath) {
        this.executeSafeUpdateCommand("DataSourceDefEditor.DataSourceHasBeenReferencedForDeleteMessage", new Command(){

            public void execute() {
                DataSourceDefEditor.this.delete(currentPath);
            }
        }, new Command(){

            public void execute() {
                DataSourceDefEditor.this.delete(currentPath);
            }
        }, new Command(){

            public void execute() {
            }
        });
    }

    protected void delete(final ObservablePath currentPath) {
        this.deletePopUpPresenter.show((ParameterizedCommand)new ParameterizedCommand<String>(){

            public void execute(String comment) {
                DataSourceDefEditor.this.view.showBusyIndicator(CommonConstants.INSTANCE.Deleting());
                ((DataSourceDefEditorService)DataSourceDefEditor.this.editorService.call((RemoteCallback)new RemoteCallback<Void>(){

                    public void callback(Void aVoid) {
                        DataSourceDefEditor.this.view.hideBusyIndicator();
                        DataSourceDefEditor.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemDeletedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                    }
                }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)DataSourceDefEditor.this.view))).delete((Path)currentPath, comment);
            }
        });
    }

    protected void executeSafeUpdateCommand(final String onDependantsMessageKey, final Command defaultCommand, final Command yesCommand, final Command noCommand) {
        ((DataSourceRuntimeManagerClientService)this.dataSourceManagerClient.call((RemoteCallback)new RemoteCallback<DataSourceDeploymentInfo>(){

            public void callback(DataSourceDeploymentInfo deploymentInfo) {
                if (deploymentInfo != null && deploymentInfo.wasReferenced()) {
                    DataSourceDefEditor.this.popupsUtil.showYesNoPopup(org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.Warning(), DataSourceDefEditor.this.editorHelper.getMessage(onDependantsMessageKey), yesCommand, org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.YES(), ButtonType.WARNING, noCommand, org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.NO(), ButtonType.DEFAULT);
                } else {
                    defaultCommand.execute();
                }
            }
        })).getDataSourceDeploymentInfo(((DataSourceDef)this.getContent().getDef()).getUuid());
    }

    protected Command onValidate() {
        return new Command(){

            public void execute() {
                Window.alert((String)"Validate DataSource, not yet implemented.");
            }
        };
    }

    private RemoteCallback<DataSourceDefEditorContent> getLoadContentSuccessCallback() {
        return new RemoteCallback<DataSourceDefEditorContent>(){

            public void callback(DataSourceDefEditorContent editorContent) {
                DataSourceDefEditor.this.view.hideBusyIndicator();
                DataSourceDefEditor.this.onContentLoaded(editorContent);
            }
        };
    }

    protected void onContentLoaded(DataSourceDefEditorContent editorContent) {
        if (this.versionRecordManager.getCurrentPath() == null) {
            return;
        }
        this.setContent(editorContent);
        this.setOriginalHash(editorContent.hashCode());
        this.editorHelper.loadDrivers(this.getLoadDriversSuccessCommand(), this.getLoadDriversErrorCommand());
    }

    protected DataSourceDefEditorContent getContent() {
        return this.editorContent;
    }

    protected void setContent(DataSourceDefEditorContent editorContent) {
        this.editorContent = editorContent;
        this.editorHelper.setDataSourceDef((DataSourceDef)editorContent.getDef());
        this.editorHelper.setProject(editorContent.getProject());
        this.editorHelper.setValid(true);
    }

    public Command getLoadDriversSuccessCommand() {
        return new Command(){

            public void execute() {
                DataSourceDefEditor.this.mainPanel.setDriver(((DataSourceDef)DataSourceDefEditor.this.getContent().getDef()).getDriverUuid());
            }
        };
    }

    public ParameterizedCommand<Throwable> getLoadDriversErrorCommand() {
        return new ParameterizedCommand<Throwable>(){

            public void execute(Throwable parameter) {
                DataSourceDefEditor.this.popupsUtil.showErrorPopup(DataSourceDefEditor.this.editorHelper.getMessage("DataSourceDefEditor.LoadDriversErrorMessage", parameter.getMessage()));
            }
        };
    }

    private void addTestMenu() {
        this.menuBuilder.addNewTopLevelMenu((MenuItem)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)this.editorHelper.getMessage("DataSourceDefEditor.TestDataSourceMenu")).respondsWith(new Command(){

            public void execute() {
                DataSourceDefEditor.this.onTestDataSource();
            }
        })).endMenu()).build().getItems().get(0));
    }

    private void onTestDataSource() {
        ((DataSourceRuntimeManagerClientService)this.dataSourceManagerClient.call((RemoteCallback)new RemoteCallback<TestResult>(){

            public void callback(TestResult testResult) {
                DataSourceDefEditor.this.popupsUtil.showInformationPopup(new SafeHtmlBuilder().appendEscapedLines(testResult.getMessage()).toSafeHtml().asString());
            }
        }, (ErrorCallback)new DefaultErrorCallback())).testDataSource(((DataSourceDef)this.getContent().getDef()).getUuid());
    }
}

