/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.explorer.common;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.LinkedGroup;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.datasource.management.client.explorer.common.DefExplorerContentView;
import org.kie.workbench.common.screens.datasource.management.client.explorer.common.DefItem;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mvp.impl.PathPlaceRequest;

@Dependent
@Templated
public class DefExplorerContentViewImpl
extends Composite
implements DefExplorerContentView {
    @DataField(value="content-accordion")
    private Element contentAccordion = DOM.createDiv();
    @Inject
    @DataField(value="datasources-panel-link")
    private Anchor dataSourcesPanelLink;
    @DataField(value="datasources-panel")
    private Element dataSourcesPanel = DOM.createDiv();
    @Inject
    @DataField(value="datasources-list-group")
    private LinkedGroup dataSourcesListGroup;
    @Inject
    @DataField(value="add-new-datasource")
    private Anchor newDataSourceLink;
    @Inject
    @DataField(value="drivers-panel-link")
    private Anchor driversPanelLink;
    @DataField(value="drivers-panel")
    private Element driversPanel = DOM.createDiv();
    @Inject
    @DataField(value="drivers-list-group")
    private LinkedGroup driversListGroup;
    @Inject
    @DataField(value="add-new-driver")
    private Anchor newDriverLink;
    private DefExplorerContentView.Presenter presenter;

    @PostConstruct
    private void init() {
        String contentAccordionId = Document.get().createUniqueId();
        this.contentAccordion.setId(contentAccordionId);
        String dataSourcesPanelId = Document.get().createUniqueId();
        this.dataSourcesPanelLink.getElement().setAttribute("data-parent", "#" + contentAccordionId);
        this.dataSourcesPanelLink.getElement().setAttribute("data-target", "#" + dataSourcesPanelId);
        this.dataSourcesPanel.setId(dataSourcesPanelId);
        String driversPanelLinkId = Document.get().createUniqueId();
        this.driversPanelLink.getElement().setAttribute("data-parent", "#" + contentAccordionId);
        this.driversPanelLink.getElement().setAttribute("data-target", "#" + driversPanelLinkId);
        this.driversPanel.setId(driversPanelLinkId);
    }

    public void init(DefExplorerContentView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void addDataSourceItem(DefItem item) {
        this.dataSourcesListGroup.add((IsWidget)item);
    }

    @Override
    public void addDriverItem(DefItem item) {
        this.driversListGroup.add((IsWidget)item);
    }

    @Override
    public void clear() {
        this.dataSourcesListGroup.clear();
        this.driversListGroup.clear();
    }

    @Override
    public void clearDataSources() {
        this.dataSourcesListGroup.clear();
    }

    @Override
    public void clearDrivers() {
        this.driversListGroup.clear();
    }

    @Override
    public PathPlaceRequest createPlaceRequest(Path path) {
        return new PathPlaceRequest(path);
    }

    @EventHandler(value={"add-new-datasource"})
    private void onAddNewDataSource(ClickEvent event) {
        this.presenter.onAddDataSource();
    }

    @EventHandler(value={"add-new-driver"})
    private void onAddNewDriver(ClickEvent event) {
        this.presenter.onAddDriver();
    }
}

