/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.explorer;

import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datasource.management.client.explorer.DataSourceDefExplorerScreenView;
import org.kie.workbench.common.screens.datasource.management.client.explorer.global.GlobalDataSourceExplorer;
import org.kie.workbench.common.screens.datasource.management.client.explorer.project.ProjectDataSourceExplorer;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@ApplicationScoped
@WorkbenchScreen(identifier="DataSourceDefExplorerScreen")
public class DataSourceDefExplorerScreen
implements DataSourceDefExplorerScreenView.Presenter {
    public static final String SCREEN_ID = "DataSourceDefExplorerScreen";
    private DataSourceDefExplorerScreenView view;
    private ProjectDataSourceExplorer projectDataSourceExplorer;
    private GlobalDataSourceExplorer globalDataSourceExplorer;
    private TranslationService translationService;
    private PlaceRequest placeRequest;
    private Menus menu;
    private boolean projectExplorerSelected = true;

    public DataSourceDefExplorerScreen() {
    }

    @Inject
    public DataSourceDefExplorerScreen(DataSourceDefExplorerScreenView view, ProjectDataSourceExplorer projectDataSourceExplorer, GlobalDataSourceExplorer globalDataSourceExplorer, TranslationService translationService) {
        this.view = view;
        this.projectDataSourceExplorer = projectDataSourceExplorer;
        this.globalDataSourceExplorer = globalDataSourceExplorer;
        this.translationService = translationService;
        view.init(this);
    }

    @PostConstruct
    public void init() {
        this.view.setProjectExplorer(this.projectDataSourceExplorer);
        this.view.setGlobalExplorer(this.globalDataSourceExplorer);
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
        this.menu = this.makeMenuBar();
        this.projectDataSourceExplorer.setActiveOrganizationalUnit(null);
        this.projectDataSourceExplorer.setActiveRepository(null);
        this.projectDataSourceExplorer.setActiveProject(null);
        this.onProjectExplorerSelected();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.getTranslation("DataSourceDefExplorerScreen.Title");
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.view.asWidget();
    }

    @WorkbenchMenu
    public Menus getMenu() {
        return this.menu;
    }

    private Menus makeMenuBar() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)this.translationService.getTranslation("DataSourceDefExplorerScreen.Refresh")).respondsWith(this.getRefreshCommand())).endMenu()).build();
    }

    private Command getRefreshCommand() {
        return new Command(){

            public void execute() {
                if (DataSourceDefExplorerScreen.this.projectExplorerSelected) {
                    DataSourceDefExplorerScreen.this.onProjectExplorerSelected();
                } else {
                    DataSourceDefExplorerScreen.this.onGlobalExplorerSelected();
                }
            }
        };
    }

    @Override
    public void onProjectExplorerSelected() {
        this.projectExplorerSelected = true;
        this.projectDataSourceExplorer.refresh();
    }

    @Override
    public void onGlobalExplorerSelected() {
        this.projectExplorerSelected = false;
        this.globalDataSourceExplorer.refresh();
    }
}

