/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.explorer.project;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.kie.workbench.common.screens.datasource.management.client.explorer.project.ProjectSelectorHandler;
import org.kie.workbench.common.screens.explorer.client.resources.i18n.ProjectExplorerConstants;
import org.kie.workbench.common.screens.explorer.client.widgets.dropdown.CustomDropdown;
import org.kie.workbench.common.screens.explorer.client.widgets.navigator.NavigatorBreadcrumbs;

public class ProjectSelector
extends Composite {
    private final FlowPanel container = new FlowPanel();
    private final CustomDropdown organizationUnits = new CustomDropdown();
    private final CustomDropdown repos = new CustomDropdown();
    private final CustomDropdown projects = new CustomDropdown();
    private NavigatorBreadcrumbs navigatorBreadcrumbs;
    private boolean isAlreadyInitialized = false;
    private List<ProjectSelectorHandler> handlers = new ArrayList<ProjectSelectorHandler>();

    public ProjectSelector() {
        this.initWidget((Widget)this.container);
    }

    public void loadOptions(Collection<OrganizationalUnit> organizationalUnits, OrganizationalUnit activeOrganizationalUnit, Collection<Repository> repositories, Repository activeRepository, Collection<Project> projects, Project activeProject) {
        this.organizationUnits.clear();
        if (organizationalUnits != null) {
            if (activeOrganizationalUnit != null) {
                this.organizationUnits.setText(activeOrganizationalUnit.getName());
            }
            for (final OrganizationalUnit ou : organizationalUnits) {
                this.organizationUnits.add(new AnchorListItem(ou.getName()){
                    {
                        super(x0);
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                ProjectSelector.this.onOrganizationalUnitSelected(ou);
                            }
                        });
                    }
                });
            }
        }
        this.repos.clear();
        if (repositories != null) {
            if (activeRepository != null) {
                this.repos.setText(activeRepository.getAlias());
            } else {
                this.repos.setText(ProjectExplorerConstants.INSTANCE.nullEntry());
            }
            for (final Repository repository : repositories) {
                this.repos.add(new AnchorListItem(repository.getAlias()){
                    {
                        super(x0);
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                ProjectSelector.this.onRepositorySelected(repository);
                            }
                        });
                    }
                });
            }
        }
        this.projects.clear();
        if (projects != null) {
            if (activeProject != null) {
                this.projects.setText(activeProject.getProjectName());
            } else {
                this.projects.setText(ProjectExplorerConstants.INSTANCE.nullEntry());
            }
            for (final Project project : projects) {
                this.projects.add(new AnchorListItem(project.getProjectName()){
                    {
                        super(x0);
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                ProjectSelector.this.onProjectSelected(project);
                            }
                        });
                    }
                });
            }
        }
        if (organizationalUnits != null && organizationalUnits.isEmpty()) {
            this.organizationUnits.setText(ProjectExplorerConstants.INSTANCE.nullEntry());
            this.organizationUnits.add(new AnchorListItem(ProjectExplorerConstants.INSTANCE.nullEntry()));
            this.repos.setText(ProjectExplorerConstants.INSTANCE.nullEntry());
            this.repos.add(new AnchorListItem(ProjectExplorerConstants.INSTANCE.nullEntry()));
            this.projects.setText(ProjectExplorerConstants.INSTANCE.nullEntry());
            this.projects.add(new AnchorListItem(ProjectExplorerConstants.INSTANCE.nullEntry()));
        } else if (repositories != null && repositories.isEmpty()) {
            this.repos.setText(ProjectExplorerConstants.INSTANCE.nullEntry());
            this.repos.add(new AnchorListItem(ProjectExplorerConstants.INSTANCE.nullEntry()));
            this.projects.setText(ProjectExplorerConstants.INSTANCE.nullEntry());
            this.projects.add(new AnchorListItem(ProjectExplorerConstants.INSTANCE.nullEntry()));
        } else if (projects != null && projects.isEmpty()) {
            this.projects.setText(ProjectExplorerConstants.INSTANCE.nullEntry());
            this.projects.add(new AnchorListItem(ProjectExplorerConstants.INSTANCE.nullEntry()));
        }
        if (!this.isAlreadyInitialized) {
            this.container.clear();
            this.setupNavigatorBreadcrumbs();
            this.addDivToAlignComponents();
            this.isAlreadyInitialized = true;
        }
    }

    public void addProjectSelectorHandler(ProjectSelectorHandler handler) {
        if (!this.handlers.contains(handler)) {
            this.handlers.add(handler);
        }
    }

    private void addDivToAlignComponents() {
        FlowPanel divClear = new FlowPanel();
        divClear.getElement().getStyle().setClear(Style.Clear.BOTH);
        this.container.add((Widget)divClear);
    }

    private void setupNavigatorBreadcrumbs() {
        this.navigatorBreadcrumbs = new NavigatorBreadcrumbs(NavigatorBreadcrumbs.Mode.HEADER){
            {
                this.build(new CustomDropdown[]{ProjectSelector.this.organizationUnits, ProjectSelector.this.repos, ProjectSelector.this.projects});
            }
        };
        FlowPanel navigatorBreadcrumbsContainer = new FlowPanel();
        navigatorBreadcrumbsContainer.getElement().getStyle().setFloat(Style.Float.LEFT);
        navigatorBreadcrumbsContainer.add((Widget)this.navigatorBreadcrumbs);
        this.container.add((Widget)navigatorBreadcrumbsContainer);
    }

    private void onOrganizationalUnitSelected(OrganizationalUnit ou) {
        for (ProjectSelectorHandler handler : this.handlers) {
            handler.onOrganizationalUnitSelected(ou);
        }
    }

    private void onRepositorySelected(Repository repository) {
        for (ProjectSelectorHandler handler : this.handlers) {
            handler.onRepositorySelected(repository);
        }
    }

    private void onProjectSelected(Project project) {
        for (ProjectSelectorHandler handler : this.handlers) {
            handler.onProjectSelected(project);
        }
    }
}

