/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.editor.datasource;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.DataSourceDefMainPanel;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.DataSourceDefMainPanelView;
import org.kie.workbench.common.screens.datasource.management.client.util.PopupsUtil;
import org.kie.workbench.common.screens.datasource.management.client.validation.ClientValidationService;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.model.DriverDefInfo;
import org.kie.workbench.common.screens.datasource.management.model.TestResult;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceDefEditorService;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceDefQueryService;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.client.validation.ValidatorCallback;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class DataSourceDefEditorHelper {
    private TranslationService translationService;
    private Caller<DataSourceDefEditorService> editorService;
    private Caller<DataSourceDefQueryService> queryService;
    private ClientValidationService validationService;
    private PopupsUtil popupsUtil;
    private DataSourceDef dataSourceDef;
    private DataSourceDefMainPanel mainPanel;
    private Map<String, DriverDefInfo> driverDefMap = new HashMap<String, DriverDefInfo>();
    private DataSourceDefMainPanelView.Handler handler;
    private Project project;
    private boolean nameValid = false;
    private boolean connectionURLValid = false;
    private boolean userValid = false;
    private boolean passwordValid = false;
    private boolean driverValid = false;

    @Inject
    public DataSourceDefEditorHelper(TranslationService translationService, Caller<DataSourceDefEditorService> editorService, Caller<DataSourceDefQueryService> queryService, ClientValidationService validationService, PopupsUtil popupsUtil) {
        this.translationService = translationService;
        this.editorService = editorService;
        this.queryService = queryService;
        this.validationService = validationService;
        this.popupsUtil = popupsUtil;
    }

    public void init(DataSourceDefMainPanel mainPanel) {
        this.mainPanel = mainPanel;
        mainPanel.setHandler(new DataSourceDefMainPanelView.Handler(){

            @Override
            public void onNameChange() {
                DataSourceDefEditorHelper.this.onNameChange();
            }

            @Override
            public void onConnectionURLChange() {
                DataSourceDefEditorHelper.this.onConnectionURLChange();
            }

            @Override
            public void onUserChange() {
                DataSourceDefEditorHelper.this.onUserChange();
            }

            @Override
            public void onPasswordChange() {
                DataSourceDefEditorHelper.this.onPasswordChange();
            }

            @Override
            public void onDriverChange() {
                DataSourceDefEditorHelper.this.onDriverChange();
            }

            @Override
            public void onTestConnection() {
                DataSourceDefEditorHelper.this.onTestConnection();
            }
        });
    }

    public void setDataSourceDef(DataSourceDef dataSourceDef) {
        this.dataSourceDef = dataSourceDef;
        this.mainPanel.clear();
        this.mainPanel.setName(dataSourceDef.getName());
        this.mainPanel.setConnectionURL(dataSourceDef.getConnectionURL());
        this.mainPanel.setUser(dataSourceDef.getUser());
        this.mainPanel.setPassword(dataSourceDef.getPassword());
        this.mainPanel.setDriver(dataSourceDef.getDriverUuid());
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setHandler(DataSourceDefMainPanelView.Handler handler) {
        this.handler = handler;
    }

    public void loadDrivers(Command onSuccessCommand, ParameterizedCommand<Throwable> onErrorCommand) {
        if (this.project == null) {
            ((DataSourceDefQueryService)this.queryService.call(this.getLoadDriversSuccessCallback(onSuccessCommand), this.getLoadDriversErrorCallback(onErrorCommand))).findGlobalDrivers();
        } else {
            ((DataSourceDefQueryService)this.queryService.call(this.getLoadDriversSuccessCallback(onSuccessCommand), this.getLoadDriversErrorCallback(onErrorCommand))).findProjectDrivers(this.project.getRootPath());
        }
    }

    private RemoteCallback<List<DriverDefInfo>> getLoadDriversSuccessCallback(final Command onSuccessCommand) {
        return new RemoteCallback<List<DriverDefInfo>>(){

            public void callback(List<DriverDefInfo> response) {
                DataSourceDefEditorHelper.this.mainPanel.loadDriverOptions(DataSourceDefEditorHelper.this.buildDriverOptions(response), true);
                onSuccessCommand.execute();
            }
        };
    }

    private ErrorCallback<?> getLoadDriversErrorCallback(final ParameterizedCommand<Throwable> onErrorCommand) {
        return new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                onErrorCommand.execute((Object)throwable);
                return false;
            }
        };
    }

    private List<Pair<String, String>> buildDriverOptions(List<DriverDefInfo> driverDefs) {
        ArrayList<Pair<String, String>> options = new ArrayList<Pair<String, String>>();
        this.driverDefMap.clear();
        for (DriverDefInfo driverDef : driverDefs) {
            options.add((Pair<String, String>)new Pair((Object)driverDef.getName(), (Object)driverDef.getUuid()));
            this.driverDefMap.put(driverDef.getUuid(), driverDef);
        }
        return options;
    }

    public void onNameChange() {
        final String newValue = this.mainPanel.getName().trim();
        this.validationService.isValidDataSourceName(newValue, new ValidatorCallback(){

            public void onSuccess() {
                DataSourceDefEditorHelper.this.onNameChange(newValue, true);
            }

            public void onFailure() {
                DataSourceDefEditorHelper.this.onNameChange(newValue, false);
            }
        });
    }

    private void onNameChange(String newValue, boolean isValid) {
        this.dataSourceDef.setName(newValue);
        this.nameValid = isValid;
        if (!this.nameValid) {
            this.mainPanel.setNameErrorMessage(this.getMessage("DataSourceDefEditor.InvalidNameMessage"));
        } else {
            this.mainPanel.clearNameErrorMessage();
        }
        if (this.handler != null) {
            this.handler.onNameChange();
        }
    }

    public void onConnectionURLChange() {
        final String newValue = this.mainPanel.getConnectionURL().trim();
        this.validationService.isValidConnectionURL(newValue, new ValidatorCallback(){

            public void onSuccess() {
                DataSourceDefEditorHelper.this.onConnectionURLChange(newValue, true);
            }

            public void onFailure() {
                DataSourceDefEditorHelper.this.onConnectionURLChange(newValue, false);
            }
        });
    }

    private void onConnectionURLChange(String newValue, boolean isValid) {
        this.dataSourceDef.setConnectionURL(newValue);
        this.connectionURLValid = isValid;
        if (!this.connectionURLValid) {
            this.mainPanel.setConnectionURLErrorMessage(this.getMessage("DataSourceDefEditor.InvalidConnectionURLMessage"));
        } else {
            this.mainPanel.clearConnectionURLErrorMessage();
        }
        if (this.handler != null) {
            this.handler.onConnectionURLChange();
        }
    }

    public void onUserChange() {
        final String newValue = this.mainPanel.getUser().trim();
        this.validationService.isNotEmpty(newValue, new ValidatorCallback(){

            public void onSuccess() {
                DataSourceDefEditorHelper.this.onUserChange(newValue, true);
            }

            public void onFailure() {
                DataSourceDefEditorHelper.this.onUserChange(newValue, false);
            }
        });
    }

    private void onUserChange(String newValue, boolean isValid) {
        this.dataSourceDef.setUser(newValue);
        this.userValid = isValid;
        if (!this.userValid) {
            this.mainPanel.setUserErrorMessage(this.getMessage("DataSourceDefEditor.InvalidUserMessage"));
        } else {
            this.mainPanel.clearUserErrorMessage();
        }
        if (this.handler != null) {
            this.handler.onUserChange();
        }
    }

    public void onPasswordChange() {
        final String newValue = this.mainPanel.getPassword().trim();
        this.validationService.isNotEmpty(newValue, new ValidatorCallback(){

            public void onSuccess() {
                DataSourceDefEditorHelper.this.onPasswordChange(newValue, true);
            }

            public void onFailure() {
                DataSourceDefEditorHelper.this.onPasswordChange(newValue, false);
            }
        });
    }

    private void onPasswordChange(String newValue, boolean isValid) {
        this.dataSourceDef.setPassword(newValue);
        this.passwordValid = isValid;
        if (!this.passwordValid) {
            this.mainPanel.setPasswordErrorMessage(this.getMessage("DataSourceDefEditor.InvalidPasswordMessage"));
        } else {
            this.mainPanel.clearPasswordErrorMessage();
        }
        if (this.handler != null) {
            this.handler.onPasswordChange();
        }
    }

    public void onDriverChange() {
        DriverDefInfo driverDef = this.driverDefMap.get(this.mainPanel.getDriver());
        boolean bl = this.driverValid = driverDef != null;
        if (!this.driverValid) {
            this.mainPanel.setDriverErrorMessage(this.getMessage("DataSourceDefEditor.DriverRequiredMessage"));
            this.dataSourceDef.setDriverUuid(null);
        } else {
            this.mainPanel.clearDriverErrorMessage();
            this.dataSourceDef.setDriverUuid(driverDef.getUuid());
        }
        if (this.handler != null) {
            this.handler.onDriverChange();
        }
    }

    public void onTestConnection() {
        if (this.project != null) {
            ((DataSourceDefEditorService)this.editorService.call(this.getTestConnectionSuccessCallback(), this.getTestConnectionErrorCallback())).testConnection(this.dataSourceDef, this.project);
        } else {
            ((DataSourceDefEditorService)this.editorService.call(this.getTestConnectionSuccessCallback(), this.getTestConnectionErrorCallback())).testConnection(this.dataSourceDef);
        }
    }

    private RemoteCallback<TestResult> getTestConnectionSuccessCallback() {
        return new RemoteCallback<TestResult>(){

            public void callback(TestResult response) {
                DataSourceDefEditorHelper.this.onTestConnectionSuccess(response);
            }
        };
    }

    public void onTestConnectionSuccess(TestResult response) {
        SafeHtmlBuilder builder = new SafeHtmlBuilder();
        if (response.isTestPassed()) {
            builder.appendEscapedLines(this.getMessage("DataSourceDefEditor.ConnectionTestSuccessfulMessage") + "\n");
        } else {
            builder.appendEscapedLines(this.getMessage("DataSourceDefEditor.ConnectionTestFailedMessage") + "\n");
        }
        builder.appendEscapedLines(response.getMessage());
        this.popupsUtil.showInformationPopup(builder.toSafeHtml().asString());
    }

    private ErrorCallback<?> getTestConnectionErrorCallback() {
        return new ErrorCallback<Object>(){

            public boolean error(Object message, Throwable throwable) {
                DataSourceDefEditorHelper.this.onTestConnectionError(message, throwable);
                return false;
            }
        };
    }

    public void onTestConnectionError(Object message, Throwable throwable) {
        SafeHtmlBuilder builder = new SafeHtmlBuilder();
        builder.appendEscapedLines(this.getMessage("DataSourceDefEditor.ConnectionTestFailedMessage") + "\n");
        builder.appendEscapedLines(throwable.getMessage());
        this.popupsUtil.showErrorPopup(builder.toSafeHtml().asString());
    }

    public void setValid(boolean valid) {
        this.nameValid = valid;
        this.connectionURLValid = valid;
        this.userValid = valid;
        this.passwordValid = valid;
        this.driverValid = valid;
    }

    public boolean isDriverValid() {
        return this.driverValid;
    }

    public boolean isNameValid() {
        return this.nameValid;
    }

    public boolean isConnectionURLValid() {
        return this.connectionURLValid;
    }

    public boolean isUserValid() {
        return this.userValid;
    }

    public boolean isPasswordValid() {
        return this.passwordValid;
    }

    public String getMessage(String messageKey) {
        return this.translationService.getTranslation(messageKey);
    }

    public String getMessage(String messageKey, Object ... args) {
        return this.translationService.format(messageKey, args);
    }
}

