/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.editor.datasource;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.DataSourceDefMainPanelView;
import org.kie.workbench.common.screens.datasource.management.client.util.UIUtil;
import org.uberfire.commons.data.Pair;

@Dependent
@Templated
public class DataSourceDefMainPanelViewImpl
extends Composite
implements DataSourceDefMainPanelView {
    @DataField(value="name-form-group")
    private Element nameFormGroup = DOM.createDiv();
    @Inject
    @DataField(value="name")
    private TextBox nameTextBox;
    @DataField(value="name-help")
    private Element nameHelp = DOM.createSpan();
    @DataField(value="connection-url-form-group")
    private Element connectionURLFormGroup = DOM.createDiv();
    @Inject
    @DataField(value="connection-url")
    private TextBox connectionURLTextBox;
    @DataField(value="connection-url-help")
    private Element connectionURLHelp = DOM.createSpan();
    @DataField(value="user-form-group")
    private Element userFormGroup = DOM.createDiv();
    @Inject
    @DataField(value="user")
    private TextBox userTextBox;
    @DataField(value="user-help")
    private Element userHelp = DOM.createSpan();
    @DataField(value="password-form-group")
    private Element passwordFormGroup = DOM.createDiv();
    @Inject
    @DataField(value="password")
    private TextBox passwordTextBox;
    @DataField(value="password-help")
    private Element passwordHelp = DOM.createSpan();
    @DataField(value="driver-form-group")
    private Element driverFormGroup = DOM.createDiv();
    @Inject
    @DataField(value="driver-selector")
    private Select driverSelector;
    @DataField(value="driver-selector-help")
    private Element driverSelectorHelp = DOM.createSpan();
    @Inject
    @DataField(value="test-connection-button")
    private Button testConnection;
    private DataSourceDefMainPanelView.Presenter presenter;

    public void init(DataSourceDefMainPanelView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setName(String name) {
        this.nameTextBox.setText(name);
    }

    @Override
    public String getName() {
        return this.nameTextBox.getText();
    }

    @Override
    public void setNameErrorMessage(String message) {
        UIUtil.setGroupOnError(this.nameFormGroup, true);
        UIUtil.setSpanMessage(this.nameHelp, message);
    }

    @Override
    public void clearNameErrorMessage() {
        UIUtil.setGroupOnError(this.nameFormGroup, false);
        UIUtil.clearSpanMessage(this.nameHelp);
    }

    @Override
    public String getConnectionURL() {
        return this.connectionURLTextBox.getText();
    }

    @Override
    public void setConnectionURL(String connectionURL) {
        this.connectionURLTextBox.setText(connectionURL);
    }

    @Override
    public void setConnectionURLErrorMessage(String message) {
        UIUtil.setGroupOnError(this.connectionURLFormGroup, true);
        UIUtil.setSpanMessage(this.connectionURLHelp, message);
    }

    @Override
    public void clearConnectionURLErrorMessage() {
        UIUtil.setGroupOnError(this.connectionURLFormGroup, false);
        UIUtil.clearSpanMessage(this.connectionURLHelp);
    }

    @Override
    public String getUser() {
        return this.userTextBox.getText();
    }

    @Override
    public void setUser(String user) {
        this.userTextBox.setText(user);
    }

    @Override
    public void setUserErrorMessage(String message) {
        UIUtil.setGroupOnError(this.userFormGroup, true);
        UIUtil.setSpanMessage(this.userHelp, message);
    }

    @Override
    public void clearUserErrorMessage() {
        UIUtil.setGroupOnError(this.userFormGroup, false);
        UIUtil.clearSpanMessage(this.userHelp);
    }

    @Override
    public String getPassword() {
        return this.passwordTextBox.getText();
    }

    @Override
    public void setPassword(String password) {
        this.passwordTextBox.setText(password);
    }

    @Override
    public void setPasswordErrorMessage(String message) {
        UIUtil.setGroupOnError(this.passwordFormGroup, true);
        UIUtil.setSpanMessage(this.passwordHelp, message);
    }

    @Override
    public void clearPasswordErrorMessage() {
        UIUtil.setGroupOnError(this.passwordFormGroup, false);
        UIUtil.clearSpanMessage(this.passwordHelp);
    }

    @Override
    public String getDriver() {
        return this.driverSelector.getValue();
    }

    @Override
    public void setDriver(String driver) {
        this.driverSelector.setValue((Object)driver);
        this.refreshDriverSelector();
    }

    @Override
    public void setDriverErrorMessage(String message) {
        UIUtil.setGroupOnError(this.driverFormGroup, true);
        UIUtil.setSpanMessage(this.driverSelectorHelp, message);
    }

    @Override
    public void clearDriverErrorMessage() {
        UIUtil.setGroupOnError(this.driverFormGroup, false);
        UIUtil.clearSpanMessage(this.driverSelectorHelp);
    }

    @Override
    public void loadDriverOptions(List<Pair<String, String>> driverOptions, boolean addEmptyOption) {
        this.driverSelector.clear();
        if (addEmptyOption) {
            this.driverSelector.add((Widget)this.newOption("", ""));
        }
        for (Pair<String, String> optionPair : driverOptions) {
            this.driverSelector.add((Widget)this.newOption((String)optionPair.getK1(), (String)optionPair.getK2()));
        }
        this.refreshDriverSelector();
    }

    @EventHandler(value={"name"})
    private void onNameChange(ChangeEvent event) {
        this.presenter.onNameChange();
    }

    @EventHandler(value={"connection-url"})
    private void onConnectionURLChange(ChangeEvent event) {
        this.presenter.onConnectionURLChange();
    }

    @EventHandler(value={"user"})
    private void onUserChange(ChangeEvent event) {
        this.presenter.onUserChange();
    }

    @EventHandler(value={"password"})
    private void onPasswordChange(ChangeEvent event) {
        this.presenter.onPasswordChange();
    }

    @EventHandler(value={"driver-selector"})
    private void onDriverChange(ChangeEvent event) {
        this.presenter.onDriverChange();
    }

    @EventHandler(value={"test-connection-button"})
    private void onTestConnection(ClickEvent event) {
        this.presenter.onTestConnection();
    }

    private Option newOption(String text, String value) {
        Option option = new Option();
        option.setValue(value);
        option.setText(text);
        return option;
    }

    private void refreshDriverSelector() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                DataSourceDefMainPanelViewImpl.this.driverSelector.refresh();
            }
        });
    }
}

