/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.explorer.project;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.screens.datasource.management.client.explorer.common.DefExplorerBase;
import org.kie.workbench.common.screens.datasource.management.client.explorer.common.DefExplorerContent;
import org.kie.workbench.common.screens.datasource.management.client.explorer.project.ProjectDataSourceExplorerView;
import org.kie.workbench.common.screens.datasource.management.client.explorer.project.ProjectSelectorHandler;
import org.kie.workbench.common.screens.datasource.management.client.wizard.datasource.NewDataSourceDefWizard;
import org.kie.workbench.common.screens.datasource.management.client.wizard.driver.NewDriverDefWizard;
import org.kie.workbench.common.screens.datasource.management.events.BaseDataSourceEvent;
import org.kie.workbench.common.screens.datasource.management.events.BaseDriverEvent;
import org.kie.workbench.common.screens.datasource.management.service.DefExplorerQuery;
import org.kie.workbench.common.screens.datasource.management.service.DefExplorerQueryResult;
import org.kie.workbench.common.screens.datasource.management.service.DefExplorerQueryService;

@Dependent
public class ProjectDataSourceExplorer
extends DefExplorerBase
implements ProjectDataSourceExplorerView.Presenter,
IsWidget {
    private ProjectDataSourceExplorerView view;
    private OrganizationalUnit activeOrganizationalUnit;
    private Repository activeRepository;
    private Project activeProject;
    private String activeBranch = "master";

    @Inject
    public ProjectDataSourceExplorer(ProjectDataSourceExplorerView view, DefExplorerContent defExplorerContent, NewDataSourceDefWizard newDataSourceDefWizard, NewDriverDefWizard newDriverDefWizard, Caller<DefExplorerQueryService> explorerService) {
        super(defExplorerContent, newDataSourceDefWizard, newDriverDefWizard, explorerService);
        this.view = view;
    }

    @Override
    @PostConstruct
    protected void init() {
        super.init();
        this.view.setDataSourceDefExplorer(this.defExplorerContent);
        this.view.addProjectSelectorHandler(new ProjectSelectorHandler(){

            @Override
            public void onOrganizationalUnitSelected(OrganizationalUnit ou) {
                ProjectDataSourceExplorer.this.onOrganizationalUnitSelected(ou);
            }

            @Override
            public void onRepositorySelected(Repository repository) {
                ProjectDataSourceExplorer.this.onRepositorySelected(repository);
            }

            @Override
            public void onProjectSelected(Project project) {
                ProjectDataSourceExplorer.this.onProjectSelected(project);
            }
        });
    }

    @Override
    public void onAddDriver() {
        Project activeProject = this.getActiveProject();
        if (activeProject == null) {
            Window.alert((String)"No project has been selected");
        } else {
            this.newDriverDefWizard.setProject(activeProject);
            this.newDriverDefWizard.start();
        }
    }

    @Override
    public void onAddDataSource() {
        Project activeProject = this.getActiveProject();
        if (activeProject == null) {
            Window.alert((String)"No project has been selected");
        } else {
            this.newDataSourceDefWizard.setProject(this.getActiveProject());
            this.newDataSourceDefWizard.start();
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    protected DefExplorerQuery createRefreshQuery() {
        return new DefExplorerQuery(this.activeOrganizationalUnit, this.activeRepository, this.activeProject, this.activeBranch);
    }

    private void refresh(DefExplorerQuery query) {
        ((DefExplorerQueryService)this.explorerService.call(this.getRefreshCallback())).executeQuery(query);
    }

    @Override
    protected void loadContent(DefExplorerQueryResult content) {
        this.defExplorerContent.clear();
        if (this.activeOrganizationalUnit == null || !this.contains(content.getOrganizationalUnits(), this.activeOrganizationalUnit)) {
            if (content.getOrganizationalUnits() != null && content.getOrganizationalUnits().size() > 0) {
                this.activeOrganizationalUnit = (OrganizationalUnit)content.getOrganizationalUnits().iterator().next();
                this.activeRepository = null;
                this.activeProject = null;
                this.refresh();
            } else {
                this.activeOrganizationalUnit = null;
                this.activeRepository = null;
                this.activeProject = null;
                this.view.clear();
            }
        } else if (this.activeRepository == null || !this.contains(content.getRepositories(), this.activeRepository)) {
            if (content.getRepositories() != null && content.getRepositories().size() > 0) {
                this.activeRepository = (Repository)content.getRepositories().iterator().next();
                this.activeProject = null;
                this.refresh();
            } else {
                this.activeRepository = null;
                this.activeProject = null;
                this.view.loadContent(content.getOrganizationalUnits(), this.activeOrganizationalUnit, new ArrayList<Repository>(), this.activeRepository, new ArrayList<Project>(), this.activeProject);
            }
        } else if (this.activeProject == null || !this.contains(content.getProjects(), this.activeProject)) {
            if (content.getProjects() != null && content.getProjects().size() > 0) {
                this.activeProject = (Project)content.getProjects().iterator().next();
                this.refresh();
            } else {
                this.activeProject = null;
                this.view.loadContent(content.getOrganizationalUnits(), this.activeOrganizationalUnit, content.getRepositories(), this.activeRepository, new ArrayList<Project>(), this.activeProject);
            }
        } else {
            this.view.loadContent(content.getOrganizationalUnits(), this.activeOrganizationalUnit, content.getRepositories(), this.activeRepository, content.getProjects(), this.activeProject);
            this.defExplorerContent.loadDataSources(content.getDataSourceDefs());
            this.defExplorerContent.loadDrivers(content.getDriverDefs());
        }
    }

    private boolean contains(Collection<Repository> repositories, Repository activeRepository) {
        if (repositories != null) {
            for (Repository repository : repositories) {
                if (!repository.getAlias().equals(activeRepository.getAlias())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(Collection<OrganizationalUnit> organizationalUnits, OrganizationalUnit activeOrganizationalUnit) {
        if (organizationalUnits != null) {
            for (OrganizationalUnit ou : organizationalUnits) {
                if (!ou.getName().equals(activeOrganizationalUnit.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean contains(Collection<Project> projects, Project activeProject) {
        if (projects != null) {
            for (Project project : projects) {
                if (!project.getRootPath().equals(activeProject.getRootPath())) continue;
                return true;
            }
        }
        return false;
    }

    public void onOrganizationalUnitSelected(OrganizationalUnit ou) {
        if (this.hasChanged(ou)) {
            this.activeOrganizationalUnit = ou;
            this.activeRepository = null;
            this.activeProject = null;
            DefExplorerQuery query = new DefExplorerQuery();
            query.setOrganizationalUnit(ou);
            this.refresh(query);
        }
    }

    public void onRepositorySelected(Repository repository) {
        if (this.hasChanged(repository)) {
            DefExplorerQuery query = new DefExplorerQuery();
            if (this.activeOrganizationalUnit != null) {
                this.activeRepository = repository;
                this.activeProject = null;
                query.setOrganizationalUnit(this.activeOrganizationalUnit);
                query.setRepository(repository);
                query.setBranch(this.activeBranch);
            } else {
                this.activeRepository = null;
                this.activeProject = null;
            }
            this.refresh(query);
        }
    }

    public void onProjectSelected(Project project) {
        if (this.hasChanged(project)) {
            DefExplorerQuery query = new DefExplorerQuery();
            if (this.activeOrganizationalUnit != null && this.activeRepository != null) {
                this.activeProject = project;
                query.setOrganizationalUnit(this.activeOrganizationalUnit);
                query.setRepository(this.activeRepository);
                query.setBranch(this.activeBranch);
                query.setProject(project);
            } else {
                this.activeProject = null;
            }
            this.refresh(query);
        }
    }

    public OrganizationalUnit getActiveOrganizationalUnit() {
        return this.activeOrganizationalUnit;
    }

    public void setActiveOrganizationalUnit(OrganizationalUnit activeOrganizationalUnit) {
        this.activeOrganizationalUnit = activeOrganizationalUnit;
    }

    public Repository getActiveRepository() {
        return this.activeRepository;
    }

    public void setActiveRepository(Repository activeRepository) {
        this.activeRepository = activeRepository;
    }

    public Project getActiveProject() {
        return this.activeProject;
    }

    public void setActiveProject(Project activeProject) {
        this.activeProject = activeProject;
    }

    public String getActiveBranch() {
        return this.activeBranch;
    }

    @Override
    protected boolean refreshOnDataSourceEvent(BaseDataSourceEvent event) {
        return !event.isGlobal() && this.activeProject != null && this.activeProject.equals((Object)event.getProject());
    }

    @Override
    protected boolean refreshOnDriverEvent(BaseDriverEvent event) {
        return !event.isGlobal() && this.activeProject != null && this.activeProject.equals((Object)event.getProject());
    }

    private boolean hasChanged(OrganizationalUnit ou) {
        return this.activeOrganizationalUnit != null ? !this.activeOrganizationalUnit.equals(ou) : ou != null;
    }

    private boolean hasChanged(Repository repository) {
        return this.activeRepository != null ? !this.activeRepository.equals(repository) : repository != null;
    }

    private boolean hasChanged(Project project) {
        return this.activeProject != null ? !this.activeProject.equals((Object)project) : project != null;
    }
}

