/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.explorer.common;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.screens.datasource.management.client.explorer.common.DefExplorerContentView;
import org.kie.workbench.common.screens.datasource.management.client.explorer.common.DefItem;
import org.kie.workbench.common.screens.datasource.management.client.explorer.common.DefItemView;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDefInfo;
import org.kie.workbench.common.screens.datasource.management.model.DriverDefInfo;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.PlaceRequest;

@Dependent
public class DefExplorerContent
implements IsWidget,
DefExplorerContentView.Presenter {
    private DefExplorerContentView view;
    private ManagedInstance<DefItem> itemInstance;
    private Map<String, DataSourceDefInfo> dataSourceItemsMap = new HashMap<String, DataSourceDefInfo>();
    private Map<String, DriverDefInfo> driverItemsMap = new HashMap<String, DriverDefInfo>();
    private PlaceManager placeManager;
    private DefExplorerContentView.Handler handler;

    @Inject
    public DefExplorerContent(DefExplorerContentView view, ManagedInstance<DefItem> itemInstance, PlaceManager placeManager) {
        this.view = view;
        this.itemInstance = itemInstance;
        this.placeManager = placeManager;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void loadDataSources(Collection<DataSourceDefInfo> dataSourceDefInfos) {
        this.clearDataSources();
        if (dataSourceDefInfos != null) {
            for (DataSourceDefInfo dataSourceDefInfo : dataSourceDefInfos) {
                String itemName = dataSourceDefInfo.getName() + (dataSourceDefInfo.isManaged() ? "" : " (external)");
                DefItem item = this.createItem();
                item.setName(itemName);
                item.addItemHandler(new DefItemView.ItemHandler(){

                    @Override
                    public void onClick(String itemId) {
                        DefExplorerContent.this.onDataSourceItemClick((DataSourceDefInfo)DefExplorerContent.this.dataSourceItemsMap.get(itemId));
                    }
                });
                this.dataSourceItemsMap.put(item.getId(), dataSourceDefInfo);
                this.view.addDataSourceItem(item);
            }
        }
    }

    public void loadDrivers(Collection<DriverDefInfo> driverDefInfos) {
        this.clearDrivers();
        if (driverDefInfos != null) {
            for (DriverDefInfo driverDefInfo : driverDefInfos) {
                DefItem item = this.createItem();
                item.setName(driverDefInfo.getName());
                item.addItemHandler(new DefItemView.ItemHandler(){

                    @Override
                    public void onClick(String itemId) {
                        DefExplorerContent.this.onDriverItemClick((DriverDefInfo)DefExplorerContent.this.driverItemsMap.get(itemId));
                    }
                });
                this.driverItemsMap.put(item.getId(), driverDefInfo);
                this.view.addDriverItem(item);
            }
        }
    }

    public void clear() {
        this.clearDataSources();
        this.clearDrivers();
    }

    public void clearDataSources() {
        this.view.clearDataSources();
        this.dataSourceItemsMap.clear();
    }

    private void clearDrivers() {
        this.view.clearDrivers();
        this.driverItemsMap.clear();
    }

    @Override
    public void onAddDataSource() {
        if (this.handler != null) {
            this.handler.onAddDataSource();
        }
    }

    @Override
    public void onAddDriver() {
        if (this.handler != null) {
            this.handler.onAddDriver();
        }
    }

    public void setHandler(DefExplorerContentView.Handler handler) {
        this.handler = handler;
    }

    protected void onDataSourceItemClick(DataSourceDefInfo dataSourceDefInfo) {
        PlaceRequest placeRequest;
        if (dataSourceDefInfo.isManaged()) {
            placeRequest = this.view.createEditorPlaceRequest(dataSourceDefInfo.getPath());
        } else {
            placeRequest = this.view.createScreenPlaceRequest("DatabaseStructureExplorerScreen");
            placeRequest.addParameter("dataSourceUuid", dataSourceDefInfo.getUuid());
            placeRequest.addParameter("dataSourceName", dataSourceDefInfo.getName());
        }
        this.placeManager.goTo(placeRequest);
    }

    protected void onDriverItemClick(DriverDefInfo driverDefInfo) {
        this.placeManager.goTo(this.view.createEditorPlaceRequest(driverDefInfo.getPath()));
    }

    protected DefItem createItem() {
        return (DefItem)this.itemInstance.get();
    }
}

