/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.wizard.datasource;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Project;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datasource.management.client.util.PopupsUtil;
import org.kie.workbench.common.screens.datasource.management.client.wizard.datasource.DataSourceDefPage;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceDefEditorService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.core.client.wizards.AbstractWizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class NewDataSourceDefWizard
extends AbstractWizard {
    private final List<WizardPage> pages = new ArrayList<WizardPage>();
    private DataSourceDefPage dataSourceDefPage;
    private DataSourceDef dataSourceDef;
    private Caller<DataSourceDefEditorService> dataSourceDefService;
    private TranslationService translationService;
    private PopupsUtil popupsUtil;
    private Event<NotificationEvent> notification;
    private Project project;

    @Inject
    public NewDataSourceDefWizard(DataSourceDefPage dataSourceDefPage, Caller<DataSourceDefEditorService> dataSourceDefService, TranslationService translationService, PopupsUtil popupsUtil, Event<NotificationEvent> notification) {
        this.dataSourceDefPage = dataSourceDefPage;
        this.dataSourceDefService = dataSourceDefService;
        this.translationService = translationService;
        this.popupsUtil = popupsUtil;
        this.notification = notification;
    }

    @PostConstruct
    public void init() {
        this.pages.add(this.dataSourceDefPage);
    }

    public void start() {
        this.dataSourceDefPage.clear();
        this.dataSourceDefPage.setComplete(false);
        this.dataSourceDef = new DataSourceDef();
        this.dataSourceDefPage.setDataSourceDef(this.dataSourceDef);
        this.dataSourceDefPage.setProject(this.project);
        this.dataSourceDefPage.loadDrivers(this.getLoadDriversSuccessCommand(), this.getLoadDriversFailureCommand());
    }

    public List<WizardPage> getPages() {
        return this.pages;
    }

    public Widget getPageWidget(int pageNumber) {
        return this.pages.get(pageNumber).asWidget();
    }

    public String getTitle() {
        return this.translationService.getTranslation("NewDataSourceDefWizard.title");
    }

    public int getPreferredHeight() {
        return 600;
    }

    public int getPreferredWidth() {
        return 700;
    }

    public void isComplete(Callback<Boolean> callback) {
        this.dataSourceDefPage.isComplete(callback);
    }

    public void complete() {
        this.doComplete();
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setGlobal() {
        this.project = null;
    }

    private void doComplete() {
        if (this.isGlobal()) {
            ((DataSourceDefEditorService)this.dataSourceDefService.call(this.getCreateSuccessCallback(), this.getCreateErrorCallback())).createGlobal(this.dataSourceDef);
        } else {
            ((DataSourceDefEditorService)this.dataSourceDefService.call(this.getCreateSuccessCallback(), this.getCreateErrorCallback())).create(this.dataSourceDef, this.project);
        }
    }

    private RemoteCallback<Path> getCreateSuccessCallback() {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                NewDataSourceDefWizard.this.notification.fire((Object)new NotificationEvent(NewDataSourceDefWizard.this.translationService.format("NewDataSourceDefWizard.DataSourceCreatedMessage", new Object[]{path.toString()})));
                NewDataSourceDefWizard.super.complete();
            }
        };
    }

    private ErrorCallback<?> getCreateErrorCallback() {
        return new DefaultErrorCallback(){

            public boolean error(Message message, Throwable throwable) {
                NewDataSourceDefWizard.this.popupsUtil.showErrorPopup(NewDataSourceDefWizard.this.translationService.format("NewDataSourceDefWizard.DataSourceCreateErrorMessage", new Object[]{NewDataSourceDefWizard.this.buildOnCreateErrorMessage(throwable)}));
                return false;
            }
        };
    }

    private Command getLoadDriversSuccessCommand() {
        return new Command(){

            public void execute() {
                NewDataSourceDefWizard.super.start();
            }
        };
    }

    private ParameterizedCommand<Throwable> getLoadDriversFailureCommand() {
        return new ParameterizedCommand<Throwable>(){

            public void execute(Throwable parameter) {
                NewDataSourceDefWizard.this.popupsUtil.showErrorPopup(NewDataSourceDefWizard.this.translationService.format("NewDataSourceDefWizard.WizardStartErrorMessage", new Object[]{parameter.getMessage()}));
            }
        };
    }

    private String buildOnCreateErrorMessage(Throwable t) {
        if (t instanceof FileAlreadyExistsException) {
            return this.translationService.format("NewDataSourceDefWizard.FileExistsErrorMessage", new Object[]{((FileAlreadyExistsException)t).getFile()});
        }
        return t.getMessage();
    }

    private boolean isGlobal() {
        return this.project == null;
    }
}

