/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.dbexplorer.tblviewer;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.uuid.UUIDGenerator;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.widgets.DisplayerViewer;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.tblviewer.TableObjectViewerView;
import org.kie.workbench.common.screens.datasource.management.service.DataManagementService;

@Dependent
public class TableObjectViewer
implements TableObjectViewerView.Presenter,
IsElement {
    private TableObjectViewerView view;
    private DisplayerViewer displayerViewer;
    private UUIDGenerator uuidGenerator;
    private Caller<DataManagementService> managementService;
    private Settings settings;

    public TableObjectViewer() {
    }

    @Inject
    public TableObjectViewer(TableObjectViewerView view, DisplayerViewer displayerViewer, UUIDGenerator uuidGenerator, Caller<DataManagementService> managementService) {
        this.view = view;
        view.init(this);
        this.displayerViewer = displayerViewer;
        this.uuidGenerator = uuidGenerator;
        this.managementService = managementService;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void initialize(Settings settings) {
        this.settings = settings;
        ((DataManagementService)this.managementService.call((RemoteCallback)new RemoteCallback<DisplayerSettings>(){

            public void callback(DisplayerSettings displayerSettings) {
                TableObjectViewer.this.initializeDisplayer(displayerSettings);
            }
        })).getDisplayerSettings(settings.dataSourceUuid(), settings.schemaName(), settings.tableName());
    }

    private void initializeDisplayer(DisplayerSettings displayerSettings) {
        this.displayerViewer.setIsShowRendererSelector(Boolean.valueOf(false));
        if (displayerSettings.getUUID() == null) {
            displayerSettings.setUUID(this.uuidGenerator.newUuid());
        }
        this.displayerViewer.init(displayerSettings);
        this.view.setContent((IsWidget)this.displayerViewer);
        this.displayerViewer.draw();
    }

    public static class Settings {
        private String dataSourceUuid;
        private String schemaName;
        private String tableName;

        public String dataSourceUuid() {
            return this.dataSourceUuid;
        }

        public Settings dataSourceUuid(String selectedDataSourceUuid) {
            this.dataSourceUuid = selectedDataSourceUuid;
            return this;
        }

        public String schemaName() {
            return this.schemaName;
        }

        public Settings schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public String tableName() {
            return this.tableName;
        }

        public Settings tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Settings settings = (Settings)o;
            if (this.dataSourceUuid != null ? !this.dataSourceUuid.equals(settings.dataSourceUuid) : settings.dataSourceUuid != null) {
                return false;
            }
            if (this.schemaName != null ? !this.schemaName.equals(settings.schemaName) : settings.schemaName != null) {
                return false;
            }
            return this.tableName != null ? this.tableName.equals(settings.tableName) : settings.tableName == null;
        }

        public int hashCode() {
            int result = this.dataSourceUuid != null ? this.dataSourceUuid.hashCode() : 0;
            result = ~(~result);
            result = 31 * result + (this.schemaName != null ? this.schemaName.hashCode() : 0);
            result = ~(~result);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = ~(~result);
            return result;
        }
    }
}

