/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.explorer.common;

import com.google.gwt.dom.client.Document;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.datasource.management.client.explorer.common.DefExplorerContentView;
import org.kie.workbench.common.screens.datasource.management.client.explorer.common.DefItem;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@Dependent
@Templated
public class DefExplorerContentViewImpl
implements DefExplorerContentView,
IsElement {
    @Inject
    @DataField(value="content-accordion")
    private Div contentAccordion;
    @Inject
    @DataField(value="datasources-panel-link")
    private Anchor dataSourcesPanelLink;
    @Inject
    @DataField(value="datasources-panel")
    private Div dataSourcesPanel;
    @Inject
    @DataField(value="datasources-list-group")
    private Div dataSourcesListGroup;
    @Inject
    @DataField(value="add-new-datasource")
    private Anchor newDataSourceLink;
    @Inject
    @DataField(value="drivers-panel-link")
    private Anchor driversPanelLink;
    @Inject
    @DataField(value="drivers-panel")
    private Div driversPanel;
    @Inject
    @DataField(value="drivers-list-group")
    private Div driversListGroup;
    @Inject
    @DataField(value="add-new-driver")
    private Anchor newDriverLink;
    private DefExplorerContentView.Presenter presenter;

    @PostConstruct
    private void init() {
        String contentAccordionId = Document.get().createUniqueId();
        this.contentAccordion.setId(contentAccordionId);
        String dataSourcesPanelId = Document.get().createUniqueId();
        this.dataSourcesPanelLink.setAttribute("data-parent", "#" + contentAccordionId);
        this.dataSourcesPanelLink.setAttribute("data-target", "#" + dataSourcesPanelId);
        this.dataSourcesPanel.setId(dataSourcesPanelId);
        String driversPanelLinkId = Document.get().createUniqueId();
        this.driversPanelLink.setAttribute("data-parent", "#" + contentAccordionId);
        this.driversPanelLink.setAttribute("data-target", "#" + driversPanelLinkId);
        this.driversPanel.setId(driversPanelLinkId);
    }

    public void init(DefExplorerContentView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void addDataSourceItem(DefItem item) {
        this.dataSourcesListGroup.appendChild((Node)item.getElement());
    }

    @Override
    public void addDriverItem(DefItem item) {
        this.driversListGroup.appendChild((Node)item.getElement());
    }

    @Override
    public void clear() {
        DOMUtil.removeAllChildren((Node)this.dataSourcesListGroup);
        DOMUtil.removeAllChildren((Node)this.driversListGroup);
    }

    @Override
    public void clearDataSources() {
        DOMUtil.removeAllChildren((Node)this.dataSourcesListGroup);
    }

    @Override
    public void clearDrivers() {
        DOMUtil.removeAllChildren((Node)this.driversListGroup);
    }

    @Override
    public PlaceRequest createEditorPlaceRequest(Path path) {
        return new PathPlaceRequest(path);
    }

    @Override
    public PlaceRequest createScreenPlaceRequest(String identifier) {
        return new DefaultPlaceRequest(identifier);
    }

    @EventHandler(value={"add-new-datasource"})
    private void onAddNewDataSource(@ForEvent(value={"click"}) Event event) {
        this.presenter.onAddDataSource();
    }

    @EventHandler(value={"add-new-driver"})
    private void onAddNewDriver(@ForEvent(value={"click"}) Event event) {
        this.presenter.onAddDriver();
    }
}

