/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.dbexplorer.dbobjects;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.gwtbootstrap3.client.ui.gwt.FlowPanel;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Label;
import org.jboss.errai.common.client.dom.TextInput;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.dbobjects.DatabaseObjectExplorerView;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.dbobjects.DatabaseObjectRow;
import org.kie.workbench.common.screens.datasource.management.client.util.UIUtil;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;

@Templated
public class DatabaseObjectExplorerViewImpl
implements DatabaseObjectExplorerView,
IsElement {
    private DatabaseObjectExplorerView.Presenter presenter;
    @Inject
    @DataField(value="header-panel")
    private Div headerPanel;
    @Inject
    @DataField(value="schema-selector-label")
    private Label schemaSelectorLabel;
    @Inject
    @DataField(value="schema-selector")
    private ListBox schemaSelector;
    @Inject
    @DataField(value="object-type-selector-label")
    private Label objectTypeSelectorLabel;
    @Inject
    @DataField(value="object-type-selector")
    private ListBox objectTypeSelector;
    @Inject
    @DataField(value="name-filter-label")
    private Label nameFilterLabel;
    @Inject
    @DataField(value="name-filter-textbox")
    private TextInput nameFilterTextBox;
    @Inject
    @DataField(value="filter-button")
    private Button filterButton;
    @Inject
    @DataField(value="results-panel")
    private FlowPanel resultsPanel;
    private PagedTable<DatabaseObjectRow> dataGrid;
    @Inject
    private TranslationService translationService;

    @PostConstruct
    private void init() {
        this.nameFilterTextBox.setAttribute("placeholder", this.translationService.getTranslation("DatabaseObjectExplorerViewImpl.namePatternHelp"));
        this.dataGrid = new PagedTable(20, (ProvidesKey)new ProvidesKey<DatabaseObjectRow>(){

            public Object getKey(DatabaseObjectRow item) {
                return item.getName();
            }
        });
        this.initializeResultsTable();
        this.resultsPanel.add(this.dataGrid);
    }

    public void init(DatabaseObjectExplorerView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public String getSchema() {
        return this.schemaSelector.getSelectedValue();
    }

    @Override
    public String getObjectType() {
        return this.objectTypeSelector.getSelectedValue();
    }

    @Override
    public String getFilterTerm() {
        return this.nameFilterTextBox.getValue();
    }

    @Override
    public void loadSchemaOptions(List<Pair<String, String>> options, String selectedOption) {
        UIUtil.loadOptions(this.schemaSelector, options, selectedOption);
    }

    @Override
    public void loadDatabaseObjectTypeOptions(List<Pair<String, String>> options) {
        UIUtil.loadOptions(this.objectTypeSelector, options);
    }

    @Override
    public void setDataProvider(AsyncDataProvider<DatabaseObjectRow> dataProvider) {
        this.dataGrid.setDataProvider(dataProvider);
    }

    @Override
    public void showHeaderPanel(boolean show) {
        this.headerPanel.setHidden(!show);
    }

    @Override
    public void showSchemaSelector(boolean show) {
        this.schemaSelectorLabel.setHidden(!show);
        this.showElement((Element)this.schemaSelector.getElement(), show);
    }

    @Override
    public void showObjectTypeFilter(boolean show) {
        this.objectTypeSelectorLabel.setHidden(!show);
        this.showElement((Element)this.objectTypeSelector.getElement(), show);
    }

    @Override
    public void showObjectNameFilter(boolean show) {
        this.nameFilterLabel.setHidden(!show);
        this.showElement((HTMLElement)this.nameFilterTextBox, show);
    }

    @Override
    public void showFilterButton(boolean show) {
        this.showElement((HTMLElement)this.filterButton, show);
    }

    @Override
    public void redraw() {
        this.dataGrid.redraw();
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @EventHandler(value={"filter-button"})
    private void onFilterClick(ClickEvent event) {
        this.presenter.onSearch();
    }

    private void initializeResultsTable() {
        this.dataGrid.setEmptyTableCaption(this.translationService.getTranslation("DatabaseObjectExplorerViewImpl.dbObjectsListEmpty"));
        this.dataGrid.setToolBarVisible(false);
        this.addNameColumn();
        this.addTypeColumn();
        this.addOpenColumn();
    }

    private void addNameColumn() {
        Column<DatabaseObjectRow, String> column = new Column<DatabaseObjectRow, String>((Cell)new TextCell()){

            public String getValue(DatabaseObjectRow row) {
                return row.getName();
            }
        };
        this.dataGrid.addColumn((Column)column, this.translationService.getTranslation("DatabaseObjectExplorerViewImpl.dbObjectNameColumn"));
        this.dataGrid.setColumnWidth((Column)column, 80.0, Style.Unit.PCT);
    }

    private void addTypeColumn() {
        Column<DatabaseObjectRow, String> column = new Column<DatabaseObjectRow, String>((Cell)new TextCell()){

            public String getValue(DatabaseObjectRow row) {
                return row.getType();
            }
        };
        this.dataGrid.addColumn((Column)column, this.translationService.getTranslation("DatabaseObjectExplorerViewImpl.dbObjectTypeColumn"));
        this.dataGrid.setColumnWidth((Column)column, 10.0, Style.Unit.PCT);
    }

    private void addOpenColumn() {
        Column<DatabaseObjectRow, String> column = new Column<DatabaseObjectRow, String>((Cell)new ButtonCell(ButtonType.DEFAULT, ButtonSize.SMALL)){

            public String getValue(DatabaseObjectRow row) {
                return DatabaseObjectExplorerViewImpl.this.translationService.getTranslation("DatabaseObjectExplorerViewImpl.dbObjectOpen");
            }
        };
        column.setFieldUpdater((FieldUpdater)new FieldUpdater<DatabaseObjectRow, String>(){

            public void update(int index, DatabaseObjectRow row, String value) {
                DatabaseObjectExplorerViewImpl.this.onOpen(row);
            }
        });
        this.dataGrid.addColumn((Column)column, this.translationService.getTranslation("DatabaseObjectExplorerViewImpl.dbObjectActionColumn"));
        this.dataGrid.setColumnWidth((Column)column, 10.0, Style.Unit.PCT);
    }

    private void onOpen(DatabaseObjectRow row) {
        this.presenter.onOpen(row);
    }

    private void showElement(Element element, boolean show) {
        element.getStyle().setDisplay(show ? Style.Display.INLINE_BLOCK : Style.Display.NONE);
    }

    private void showElement(HTMLElement element, boolean show) {
        element.getStyle().setProperty("display", show ? Style.Display.INLINE_BLOCK.getCssName() : Style.Display.NONE.getCssName());
    }
}

