/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.dbexplorer.schemas;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.gwtbootstrap3.client.ui.gwt.FlowPanel;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.schemas.DatabaseSchemaExplorerView;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.schemas.DatabaseSchemaRow;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;

@Templated
public class DatabaseSchemaExplorerViewImpl
implements DatabaseSchemaExplorerView,
IsElement {
    private DatabaseSchemaExplorerView.Presenter presenter;
    @Inject
    @DataField(value="content-panel")
    private FlowPanel contentPanel;
    private PagedTable<DatabaseSchemaRow> dataGrid;
    @Inject
    private TranslationService translationService;

    @PostConstruct
    private void init() {
        this.dataGrid = new PagedTable(20, (ProvidesKey)new ProvidesKey<DatabaseSchemaRow>(){

            public Object getKey(DatabaseSchemaRow item) {
                return item.getName();
            }
        });
        this.initializeTable();
        this.contentPanel.add(this.dataGrid);
    }

    public void init(DatabaseSchemaExplorerView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setDataProvider(AsyncDataProvider<DatabaseSchemaRow> dataProvider) {
        this.dataGrid.setDataProvider(dataProvider);
    }

    @Override
    public void redraw() {
        this.dataGrid.redraw();
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    private void initializeTable() {
        this.dataGrid.setEmptyTableCaption(this.translationService.getTranslation("DatabaseSchemaExplorerViewImpl.schemasListEmpty"));
        this.dataGrid.setToolBarVisible(false);
        this.addNameColumn();
        this.addOpenColumn();
    }

    private void addNameColumn() {
        Column<DatabaseSchemaRow, String> column = new Column<DatabaseSchemaRow, String>((Cell)new TextCell()){

            public String getValue(DatabaseSchemaRow row) {
                return row.getName();
            }
        };
        this.dataGrid.addColumn((Column)column, this.translationService.getTranslation("DatabaseSchemaExplorerViewImpl.schemaNameColumn"));
        this.dataGrid.setColumnWidth((Column)column, 80.0, Style.Unit.PCT);
    }

    private void addOpenColumn() {
        Column<DatabaseSchemaRow, String> column = new Column<DatabaseSchemaRow, String>((Cell)new ButtonCell(ButtonType.DEFAULT, ButtonSize.SMALL)){

            public String getValue(DatabaseSchemaRow row) {
                return DatabaseSchemaExplorerViewImpl.this.translationService.getTranslation("DatabaseSchemaExplorerViewImpl.schemaOpenAction");
            }
        };
        column.setFieldUpdater((FieldUpdater)new FieldUpdater<DatabaseSchemaRow, String>(){

            public void update(int index, DatabaseSchemaRow row, String value) {
                DatabaseSchemaExplorerViewImpl.this.onOpen(row);
            }
        });
        this.dataGrid.addColumn((Column)column, this.translationService.getTranslation("DatabaseSchemaExplorerViewImpl.actionColumn"));
        this.dataGrid.setColumnWidth((Column)column, 10.0, Style.Unit.PCT);
    }

    private void onOpen(DatabaseSchemaRow row) {
        this.presenter.onOpen(row);
    }
}

