/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.editor.datasource;

import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.DatabaseStructureExplorer;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.DatabaseStructureExplorerView;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.DataSourceDefEditorHelper;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.DataSourceDefEditorView;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.DataSourceDefMainPanel;
import org.kie.workbench.common.screens.datasource.management.client.type.DataSourceDefType;
import org.kie.workbench.common.screens.datasource.management.client.util.InitializeCallback;
import org.kie.workbench.common.screens.datasource.management.client.util.PopupsUtil;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDefEditorContent;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceDefEditorService;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceRuntimeManagerClientService;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.editor.commons.client.BaseEditor;
import org.uberfire.ext.editor.commons.client.BaseEditorView;
import org.uberfire.ext.editor.commons.client.file.popups.DeletePopUpPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@WorkbenchEditor(identifier="DataSourceDefEditor", supportedTypes={DataSourceDefType.class})
public class DataSourceDefEditor
extends BaseEditor<DataSourceDefEditorContent, Metadata>
implements DataSourceDefEditorView.Presenter {
    private DataSourceDefEditorView view;
    private DataSourceDefMainPanel mainPanel;
    private DataSourceDefEditorHelper editorHelper;
    private DatabaseStructureExplorer dbStructureExplorer;
    private PopupsUtil popupsUtil;
    private PlaceManager placeManager;
    private DataSourceDefType type;
    private Caller<DataSourceDefEditorService> editorService;
    private Caller<DataSourceRuntimeManagerClientService> dataSourceManagerClient;
    private DataSourceDefEditorContent editorContent;
    private SavePopUpPresenter savePopUpPresenter;
    private DeletePopUpPresenter deletePopUpPresenter;

    @Inject
    public DataSourceDefEditor(DataSourceDefEditorView view, DataSourceDefMainPanel mainPanel, DataSourceDefEditorHelper editorHelper, DatabaseStructureExplorer dbStructureExplorer, PopupsUtil popupsUtil, PlaceManager placeManager, DataSourceDefType type, SavePopUpPresenter savePopUpPresenter, DeletePopUpPresenter deletePopUpPresenter, Caller<DataSourceDefEditorService> editorService, Caller<DataSourceRuntimeManagerClientService> dataSourceManagerClient) {
        super((BaseEditorView)view);
        this.view = view;
        this.mainPanel = mainPanel;
        this.editorHelper = editorHelper;
        this.dbStructureExplorer = dbStructureExplorer;
        this.popupsUtil = popupsUtil;
        this.placeManager = placeManager;
        this.type = type;
        this.savePopUpPresenter = savePopUpPresenter;
        this.deletePopUpPresenter = deletePopUpPresenter;
        this.editorService = editorService;
        this.dataSourceManagerClient = dataSourceManagerClient;
        view.init(this);
        editorHelper.init(mainPanel);
    }

    @PostConstruct
    protected void init() {
        this.showEditor();
        this.dbStructureExplorer.addHandler(new DatabaseStructureExplorerView.Handler(){

            @Override
            public void onDataSourceSelected() {
                DataSourceDefEditor.this.showEditor();
            }
        });
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.init(path, place, this.type, true, false, new MenuItems[0]);
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.view.asWidget();
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose(Integer.valueOf(this.getContent().hashCode()));
    }

    protected void loadContent() {
        ((DataSourceDefEditorService)this.editorService.call(this.getLoadContentSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    public boolean mayClose(Integer currentHash) {
        return super.mayClose(currentHash);
    }

    @Override
    public void onSave() {
        this.save();
    }

    @Override
    public void onCancel() {
        this.placeManager.closePlace(this.place);
    }

    @Override
    public void onDelete() {
        this.safeDelete(this.versionRecordManager.getCurrentPath());
    }

    protected void save() {
        if (!(this.editorHelper.isNameValid() && this.editorHelper.isConnectionURLValid() && this.editorHelper.isUserValid() && this.editorHelper.isPasswordValid() && this.editorHelper.isDriverValid())) {
            this.popupsUtil.showInformationPopup(this.editorHelper.getMessage("DataSourceDefEditor.AllFieldsRequiresValidation"));
        } else {
            this.safeSave();
        }
    }

    protected void safeSave() {
        this.executeSafeUpdateCommand("DataSourceDefEditor.DataSourceHasBeenReferencedForSaveMessage", new Command(){

            public void execute() {
                DataSourceDefEditor.this._save();
            }
        }, new Command(){

            public void execute() {
                DataSourceDefEditor.this._save();
            }
        }, new Command(){

            public void execute() {
            }
        });
    }

    protected void _save() {
        this.savePopUpPresenter.show((Path)this.versionRecordManager.getCurrentPath(), (ParameterizedCommand)new ParameterizedCommand<String>(){

            public void execute(String commitMessage) {
                ((DataSourceDefEditorService)DataSourceDefEditor.this.editorService.call(DataSourceDefEditor.this.getSaveSuccessCallback(DataSourceDefEditor.this.getContent().hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)DataSourceDefEditor.this.view))).save((Path)DataSourceDefEditor.this.versionRecordManager.getCurrentPath(), DataSourceDefEditor.this.getContent(), commitMessage);
            }
        });
        this.concurrentUpdateSessionInfo = null;
    }

    protected void safeDelete(final ObservablePath currentPath) {
        this.executeSafeUpdateCommand("DataSourceDefEditor.DataSourceHasBeenReferencedForDeleteMessage", new Command(){

            public void execute() {
                DataSourceDefEditor.this.delete(currentPath);
            }
        }, new Command(){

            public void execute() {
                DataSourceDefEditor.this.delete(currentPath);
            }
        }, new Command(){

            public void execute() {
            }
        });
    }

    protected void delete(final ObservablePath currentPath) {
        this.deletePopUpPresenter.show((ParameterizedCommand)new ParameterizedCommand<String>(){

            public void execute(String comment) {
                DataSourceDefEditor.this.view.showBusyIndicator(CommonConstants.INSTANCE.Deleting());
                ((DataSourceDefEditorService)DataSourceDefEditor.this.editorService.call((RemoteCallback)new RemoteCallback<Void>(){

                    public void callback(Void aVoid) {
                        DataSourceDefEditor.this.view.hideBusyIndicator();
                        DataSourceDefEditor.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemDeletedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                    }
                }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)DataSourceDefEditor.this.view))).delete((Path)currentPath, comment);
            }
        });
    }

    protected void executeSafeUpdateCommand(final String onDependantsMessageKey, final Command defaultCommand, final Command yesCommand, final Command noCommand) {
        ((DataSourceRuntimeManagerClientService)this.dataSourceManagerClient.call((RemoteCallback)new RemoteCallback<DataSourceDeploymentInfo>(){

            public void callback(DataSourceDeploymentInfo deploymentInfo) {
                if (deploymentInfo != null && deploymentInfo.wasReferenced()) {
                    DataSourceDefEditor.this.popupsUtil.showYesNoPopup(org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.Warning(), DataSourceDefEditor.this.editorHelper.getMessage(onDependantsMessageKey), yesCommand, org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.YES(), ButtonType.WARNING, noCommand, org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants.INSTANCE.NO(), ButtonType.DEFAULT);
                } else {
                    defaultCommand.execute();
                }
            }
        })).getDataSourceDeploymentInfo(((DataSourceDef)this.getContent().getDef()).getUuid());
    }

    private RemoteCallback<DataSourceDefEditorContent> getLoadContentSuccessCallback() {
        return new RemoteCallback<DataSourceDefEditorContent>(){

            public void callback(DataSourceDefEditorContent editorContent) {
                DataSourceDefEditor.this.view.hideBusyIndicator();
                DataSourceDefEditor.this.onContentLoaded(editorContent);
            }
        };
    }

    protected void onContentLoaded(DataSourceDefEditorContent editorContent) {
        if (this.versionRecordManager.getCurrentPath() == null) {
            return;
        }
        this.setContent(editorContent);
        this.setOriginalHash(editorContent.hashCode());
        this.editorHelper.loadDrivers(this.getLoadDriversSuccessCommand(), this.getLoadDriversErrorCommand());
    }

    protected DataSourceDefEditorContent getContent() {
        return this.editorContent;
    }

    protected void setContent(DataSourceDefEditorContent editorContent) {
        this.editorContent = editorContent;
        this.view.setDataSourceName(((DataSourceDef)editorContent.getDef()).getName());
        this.editorHelper.setDataSourceDef((DataSourceDef)editorContent.getDef());
        this.editorHelper.setModule(editorContent.getModule());
        this.editorHelper.setValid(true);
    }

    public Command getLoadDriversSuccessCommand() {
        return new Command(){

            public void execute() {
                DataSourceDefEditor.this.mainPanel.setDriver(((DataSourceDef)DataSourceDefEditor.this.getContent().getDef()).getDriverUuid());
            }
        };
    }

    public ParameterizedCommand<Throwable> getLoadDriversErrorCommand() {
        return new ParameterizedCommand<Throwable>(){

            public void execute(Throwable parameter) {
                DataSourceDefEditor.this.popupsUtil.showErrorPopup(DataSourceDefEditor.this.editorHelper.getMessage("DataSourceDefEditor.LoadDriversErrorMessage", parameter.getMessage()));
            }
        };
    }

    @Override
    public void onShowContent() {
        DatabaseStructureExplorer.Settings settings = new DatabaseStructureExplorer.Settings().dataSourceUuid(((DataSourceDef)this.getContent().getDef()).getUuid()).dataSourceName(((DataSourceDef)this.getContent().getDef()).getName());
        this.dbStructureExplorer.initialize(settings, new InitializeCallback(){

            @Override
            public void onInitializeError(Throwable throwable) {
            }

            @Override
            public void onInitializeSuccess() {
                DataSourceDefEditor.this.showContent();
            }
        });
    }

    private void showEditor() {
        this.view.clearContent();
        this.view.setContentWidth("col-md-8");
        this.view.setContent(this.mainPanel);
        this.view.showHeaderPanel(true);
        this.view.showActionsPanel(true);
    }

    private void showContent() {
        this.view.showHeaderPanel(false);
        this.view.showActionsPanel(false);
        this.view.clearContent();
        this.view.setContentWidth("col-md-12");
        this.view.setContent(this.dbStructureExplorer);
    }
}

