/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.dbexplorer.dbobjects;

import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.dbobjects.DatabaseObjectExplorerView;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.dbobjects.DatabaseObjectRow;
import org.kie.workbench.common.screens.datasource.management.client.util.InitializeCallback;
import org.kie.workbench.common.screens.datasource.management.metadata.DatabaseMetadata;
import org.kie.workbench.common.screens.datasource.management.metadata.SchemaMetadata;
import org.kie.workbench.common.screens.datasource.management.metadata.TableMetadata;
import org.kie.workbench.common.screens.datasource.management.service.DatabaseMetadataService;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;

@Dependent
public class DatabaseObjectExplorer
implements DatabaseObjectExplorerView.Presenter,
IsElement {
    private DatabaseObjectExplorerView view;
    private Caller<DatabaseMetadataService> metadataService;
    private AsyncDataProvider<DatabaseObjectRow> dataProvider;
    private TranslationService translationService;
    private List<DatabaseObjectRow> rows = new ArrayList<DatabaseObjectRow>();
    private Settings settings;
    private DatabaseObjectExplorerView.Handler handler;
    protected static final DatabaseMetadata.TableType[] availableSearchTypes = new DatabaseMetadata.TableType[]{DatabaseMetadata.TableType.VIEW, DatabaseMetadata.TableType.TABLE};

    public DatabaseObjectExplorer() {
    }

    @Inject
    public DatabaseObjectExplorer(DatabaseObjectExplorerView view, Caller<DatabaseMetadataService> metadataService, TranslationService translationService) {
        this.view = view;
        view.init(this);
        this.metadataService = metadataService;
        this.translationService = translationService;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @PostConstruct
    protected void init() {
        this.setObjectOptions();
        this.dataProvider = new AsyncDataProvider<DatabaseObjectRow>(){

            protected void onRangeChanged(HasData<DatabaseObjectRow> display) {
                this.updateRowCount(DatabaseObjectExplorer.this.rows.size(), true);
                this.updateRowData(0, DatabaseObjectExplorer.this.rows);
            }
        };
        this.view.setDataProvider(this.dataProvider);
    }

    public void initialize(Settings settings) {
        this.initialize(settings, null);
    }

    public void initialize(Settings settings, InitializeCallback initializeCallback) {
        this.settings = settings;
        this.view.showSchemaSelector(settings.isShowSchemaSelection());
        this.view.showObjectTypeFilter(settings.isShowObjectTypeFilter());
        this.view.showObjectNameFilter(settings.isShowObjectNameFilter());
        boolean hasFilter = settings.isShowSchemaSelection() || settings.isShowObjectTypeFilter() || settings.isShowObjectNameFilter();
        this.view.showFilterButton(hasFilter);
        this.view.showHeaderPanel(hasFilter);
        if (settings.isShowSchemaSelection()) {
            this.loadSchemas(settings.dataSourceUuid(), settings.schemaName(), initializeCallback);
        } else {
            this.search(settings.dataSourceUuid(), settings.schemaName(), DatabaseMetadata.TableType.ALL.name(), "%", initializeCallback);
        }
    }

    public void addHandler(DatabaseObjectExplorerView.Handler handler) {
        this.handler = handler;
    }

    @Override
    public void onSearch() {
        this.search(this.settings.dataSourceUuid(), this.getSchema(), this.view.getObjectType(), this.view.getFilterTerm());
    }

    @Override
    public void onOpen(DatabaseObjectRow row) {
        this.handler.onOpen(this.getSchema(), row.getName());
    }

    protected List<DatabaseObjectRow> getItems() {
        return this.rows;
    }

    private String getSchema() {
        if (this.settings.isShowSchemaSelection()) {
            return this.view.getSchema();
        }
        return this.settings.schemaName();
    }

    private void clear() {
        this.rows.clear();
        this.refreshRows();
    }

    private void refreshRows() {
        this.dataProvider.updateRowCount(this.rows.size(), true);
        this.dataProvider.updateRowData(0, this.rows);
        this.view.redraw();
    }

    private void loadSchemas(String dataSourceUuid, String selectedSchema, final InitializeCallback initializeCallback) {
        this.view.showBusyIndicator(this.translationService.getTranslation("DatabaseObjectExplorerViewImpl.loadingDbSchemas"));
        ((DatabaseMetadataService)this.metadataService.call(this.getLoadSchemasSuccessCallback(selectedSchema, initializeCallback), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback(this.view){

            public boolean error(Message message, Throwable throwable) {
                boolean result = super.error(message, throwable);
                if (initializeCallback != null) {
                    initializeCallback.onInitializeError(throwable);
                }
                return result;
            }
        })).getMetadata(dataSourceUuid, false, true);
    }

    private RemoteCallback<DatabaseMetadata> getLoadSchemasSuccessCallback(final String selectedSchema, final InitializeCallback initializeCallback) {
        return new RemoteCallback<DatabaseMetadata>(){

            public void callback(DatabaseMetadata metadata) {
                DatabaseObjectExplorer.this.view.hideBusyIndicator();
                String currentSchema = selectedSchema;
                if (currentSchema == null && !metadata.getSchemas().isEmpty()) {
                    currentSchema = ((SchemaMetadata)metadata.getSchemas().get(0)).getSchemaName();
                }
                DatabaseObjectExplorer.this.loadSchemas(metadata, currentSchema);
                DatabaseObjectExplorer.this.search(DatabaseObjectExplorer.this.settings.dataSourceUuid(), currentSchema, DatabaseMetadata.TableType.ALL.name(), "%", initializeCallback);
            }
        };
    }

    private void loadSchemas(DatabaseMetadata metadata, String selectedSchema) {
        String currentSchema = null;
        ArrayList<Pair<String, String>> options = new ArrayList<Pair<String, String>>();
        for (SchemaMetadata schemaMetadata : metadata.getSchemas()) {
            if (schemaMetadata.getSchemaName().equals(selectedSchema)) {
                currentSchema = selectedSchema;
            }
            options.add((Pair<String, String>)new Pair((Object)schemaMetadata.getSchemaName(), (Object)schemaMetadata.getSchemaName()));
        }
        if (currentSchema == null && !metadata.getSchemas().isEmpty()) {
            currentSchema = ((SchemaMetadata)metadata.getSchemas().get(0)).getSchemaName();
        }
        this.view.loadSchemaOptions(options, currentSchema);
    }

    private void search(String dataSource, String schema, String databaseObjectType, String searchTerm) {
        this.search(dataSource, schema, databaseObjectType, searchTerm, null);
    }

    private void search(String dataSource, String schema, String databaseObjectType, String searchTerm, final InitializeCallback initializeCallback) {
        this.clear();
        this.view.showBusyIndicator(this.translationService.getTranslation("DatabaseObjectExplorerViewImpl.loadingDbObjects"));
        ((DatabaseMetadataService)this.metadataService.call(this.getSearchSuccessCallback(initializeCallback), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback(this.view){

            public boolean error(Message message, Throwable throwable) {
                boolean result = super.error(message, throwable);
                if (initializeCallback != null) {
                    initializeCallback.onInitializeError(throwable);
                }
                return result;
            }
        })).findTables(dataSource, schema, this.buildSearchTerm(searchTerm), this.buildSearchType(this.view.getObjectType()));
    }

    private RemoteCallback<List<TableMetadata>> getSearchSuccessCallback(final InitializeCallback initializeCallback) {
        return new RemoteCallback<List<TableMetadata>>(){

            public void callback(List<TableMetadata> response) {
                DatabaseObjectExplorer.this.view.hideBusyIndicator();
                DatabaseObjectExplorer.this.loadTables(response);
                if (initializeCallback != null) {
                    initializeCallback.onInitializeSuccess();
                }
            }
        };
    }

    private void loadTables(List<TableMetadata> response) {
        this.rows.clear();
        for (TableMetadata metadata : response) {
            this.rows.add(new DatabaseObjectRow(metadata.getTableName(), metadata.getTableType()));
        }
        this.refreshRows();
    }

    private void setObjectOptions() {
        ArrayList<Pair<String, String>> options = new ArrayList<Pair<String, String>>();
        options.add(new Pair((Object)DatabaseMetadata.TableType.ALL.name(), (Object)DatabaseMetadata.TableType.ALL.name()));
        options.add(new Pair((Object)DatabaseMetadata.TableType.TABLE.name(), (Object)DatabaseMetadata.TableType.TABLE.name()));
        options.add(new Pair((Object)DatabaseMetadata.TableType.VIEW.name(), (Object)DatabaseMetadata.TableType.VIEW.name()));
        this.view.loadDatabaseObjectTypeOptions(options);
    }

    private String buildSearchTerm(String searchTerm) {
        if (searchTerm == null || searchTerm.trim().isEmpty()) {
            return "%";
        }
        return "%" + searchTerm.trim() + "%";
    }

    private DatabaseMetadata.TableType[] buildSearchType(String searchType) {
        if (searchType == null || DatabaseMetadata.TableType.ALL.name().equals(searchType)) {
            return availableSearchTypes;
        }
        return new DatabaseMetadata.TableType[]{DatabaseMetadata.TableType.valueOf((String)searchType)};
    }

    public static class Settings {
        private String dataSourceUuid;
        private String schemaName;
        private boolean showSchemaSelection;
        private boolean showObjectTypeFilter;
        private boolean showObjectNameFilter;

        public String dataSourceUuid() {
            return this.dataSourceUuid;
        }

        public Settings dataSourceUuid(String selectedDataSourceUuid) {
            this.dataSourceUuid = selectedDataSourceUuid;
            return this;
        }

        public String schemaName() {
            return this.schemaName;
        }

        public Settings schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public boolean isShowSchemaSelection() {
            return this.showSchemaSelection;
        }

        public Settings showSchemaSelection(boolean showSchemaSelection) {
            this.showSchemaSelection = showSchemaSelection;
            return this;
        }

        public boolean isShowObjectTypeFilter() {
            return this.showObjectTypeFilter;
        }

        public Settings showObjectTypeFilter(boolean showObjectTypeFilter) {
            this.showObjectTypeFilter = showObjectTypeFilter;
            return this;
        }

        public boolean isShowObjectNameFilter() {
            return this.showObjectNameFilter;
        }

        public Settings showObjectNameFilter(boolean showObjectNameFilter) {
            this.showObjectNameFilter = showObjectNameFilter;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Settings settings = (Settings)o;
            if (this.showSchemaSelection != settings.showSchemaSelection) {
                return false;
            }
            if (this.showObjectTypeFilter != settings.showObjectTypeFilter) {
                return false;
            }
            if (this.showObjectNameFilter != settings.showObjectNameFilter) {
                return false;
            }
            if (this.dataSourceUuid != null ? !this.dataSourceUuid.equals(settings.dataSourceUuid) : settings.dataSourceUuid != null) {
                return false;
            }
            return this.schemaName != null ? this.schemaName.equals(settings.schemaName) : settings.schemaName == null;
        }

        public int hashCode() {
            int result = this.dataSourceUuid != null ? this.dataSourceUuid.hashCode() : 0;
            result = ~(~result);
            result = 31 * result + (this.schemaName != null ? this.schemaName.hashCode() : 0);
            result = ~(~result);
            result = 31 * result + (this.showSchemaSelection ? 1 : 0);
            result = ~(~result);
            result = 31 * result + (this.showObjectTypeFilter ? 1 : 0);
            result = ~(~result);
            result = 31 * result + (this.showObjectNameFilter ? 1 : 0);
            result = ~(~result);
            return result;
        }
    }
}

