/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.editor.datasource.selector;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.gwtbootstrap3.client.ui.gwt.FlowPanel;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.selector.DataSourceSelectorPageRow;
import org.kie.workbench.common.screens.datasource.management.client.editor.datasource.selector.DataSourceSelectorView;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;

@Templated
@Dependent
public class DataSourceSelectorViewImpl
extends Composite
implements DataSourceSelectorView {
    private DataSourceSelectorView.Presenter presenter;
    private BaseModal modal;
    @Inject
    @DataField(value="main-panel")
    private FlowPanel mainPanel;
    @Inject
    private PagedTable<DataSourceSelectorPageRow> dataGrid = new PagedTable();
    private DataSourceSelectorPageRow selectedRow;
    private boolean cancelNextHiddenEvent = false;
    @Inject
    private TranslationService translationService;

    @PostConstruct
    private void init() {
        this.dataGrid.setHeight("200px");
        this.dataGrid.setColumnPickerButtonVisible(false);
        this.dataGrid.setEmptyTableCaption(this.translationService.getTranslation("DataSourceSelector.NoAvailableDataSourcesMessage"));
        Column<DataSourceSelectorPageRow, String> nameColumn = new Column<DataSourceSelectorPageRow, String>((Cell)new TextCell()){

            public String getValue(DataSourceSelectorPageRow row) {
                return row.getDataSourceDefInfo().getName();
            }
        };
        this.dataGrid.addColumn((Column)nameColumn, this.translationService.getTranslation("DataSourceSelector.DataSourceColumn"));
        Column<DataSourceSelectorPageRow, String> selectorColumn = new Column<DataSourceSelectorPageRow, String>((Cell)new ButtonCell(ButtonType.PRIMARY, ButtonSize.SMALL)){

            public String getValue(DataSourceSelectorPageRow row) {
                return DataSourceSelectorViewImpl.this.translationService.getTranslation("DataSourceSelector.SelectButton");
            }
        };
        selectorColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<DataSourceSelectorPageRow, String>(){

            public void update(int index, DataSourceSelectorPageRow row, String value) {
                DataSourceSelectorViewImpl.this.selectedRow = row;
                DataSourceSelectorViewImpl.this.cancelNextHiddenEvent = true;
                DataSourceSelectorViewImpl.this.modal.hide();
                DataSourceSelectorViewImpl.this.presenter.onSelect();
            }
        });
        this.dataGrid.addColumn((Column)selectorColumn, "");
        this.mainPanel.add(this.dataGrid);
        this.modal = new BaseModal();
        this.modal.setTitle(this.translationService.getTranslation("DataSourceSelector.Title"));
        this.modal.setBody((Widget)this);
        this.modal.addHiddenHandler(new ModalHiddenHandler(){

            public void onHidden(ModalHiddenEvent evt) {
                if (!DataSourceSelectorViewImpl.this.cancelNextHiddenEvent) {
                    DataSourceSelectorViewImpl.this.presenter.onClose();
                }
                DataSourceSelectorViewImpl.this.cancelNextHiddenEvent = false;
            }
        });
    }

    public void init(DataSourceSelectorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public HasData<DataSourceSelectorPageRow> getDisplay() {
        return this.dataGrid;
    }

    @Override
    public DataSourceSelectorPageRow getSelectedRow() {
        return this.selectedRow;
    }

    @Override
    public void show() {
        this.cancelNextHiddenEvent = false;
        this.modal.show();
    }
}

