/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.client.dbexplorer;

import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.DatabaseStructureExplorerView;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.dbobjects.DatabaseObjectExplorer;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.dbobjects.DatabaseObjectExplorerView;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.schemas.DatabaseSchemaExplorer;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.schemas.DatabaseSchemaExplorerView;
import org.kie.workbench.common.screens.datasource.management.client.dbexplorer.tblviewer.TableObjectViewer;
import org.kie.workbench.common.screens.datasource.management.client.util.InitializeCallback;
import org.kie.workbench.common.screens.datasource.management.client.widgets.BreadcrumbItem;
import org.uberfire.mvp.Command;

@Dependent
public class DatabaseStructureExplorer
implements DatabaseStructureExplorerView.Presenter,
IsElement {
    private DatabaseStructureExplorerView view;
    private DatabaseSchemaExplorer schemaExplorer;
    private DatabaseObjectExplorer objectExplorer;
    private TableObjectViewer objectViewer;
    private ManagedInstance<BreadcrumbItem> itemInstance;
    private BreadcrumbItem dataSourceBreadcrumbItem;
    private BreadcrumbItem schemasBreadcrumbItem;
    private BreadcrumbItem objectsBreadcrumbItem;
    private BreadcrumbItem objectViewerBreadcrumbItem;
    private TranslationService translationService;
    private Settings settings;
    private DatabaseStructureExplorerView.Handler handler;

    public DatabaseStructureExplorer() {
    }

    @Inject
    public DatabaseStructureExplorer(DatabaseStructureExplorerView view, DatabaseSchemaExplorer schemaExplorer, DatabaseObjectExplorer objectExplorer, TableObjectViewer objectViewer, ManagedInstance<BreadcrumbItem> itemInstance, TranslationService translationService) {
        this.view = view;
        view.init(this);
        this.schemaExplorer = schemaExplorer;
        this.objectExplorer = objectExplorer;
        this.objectViewer = objectViewer;
        this.itemInstance = itemInstance;
        this.translationService = translationService;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @PostConstruct
    protected void init() {
        this.dataSourceBreadcrumbItem = this.createDataSourceBreadcrumbItem();
        this.schemasBreadcrumbItem = this.createSchemasBreadcrumbItem();
        this.objectsBreadcrumbItem = this.createObjectsBreadcrumbItem();
        this.objectViewerBreadcrumbItem = this.createObjectViewerBreadcrumbItem();
        this.schemaExplorer.addHandler(new DatabaseSchemaExplorerView.Handler(){

            @Override
            public void onOpen(String schemaName) {
                DatabaseStructureExplorer.this.onSchemaSelected(schemaName);
            }
        });
        this.objectExplorer.addHandler(new DatabaseObjectExplorerView.Handler(){

            @Override
            public void onOpen(String schemaName, String objectName) {
                DatabaseStructureExplorer.this.onDataBaseObjectSelected(schemaName, objectName);
            }
        });
    }

    public void initialize(Settings settings) {
        this.initialize(settings, null);
    }

    public void initialize(Settings settings, final InitializeCallback callback) {
        this.settings = settings;
        this.dataSourceBreadcrumbItem.setName(settings.dataSourceName());
        this.schemaExplorer.initialize(new DatabaseSchemaExplorer.Settings().dataSourceUuid(settings.dataSourceUuid()), new InitializeCallback(){

            @Override
            public void onInitializeError(Throwable throwable) {
                if (callback != null) {
                    callback.onInitializeError(throwable);
                }
            }

            @Override
            public void onInitializeSuccess() {
                DatabaseStructureExplorer.this.showSchemas();
                if (callback != null) {
                    callback.onInitializeSuccess();
                }
            }
        });
    }

    public void addHandler(DatabaseStructureExplorerView.Handler handler) {
        this.handler = handler;
    }

    protected void showSchemas() {
        if (this.schemaExplorer.hasItems()) {
            this.clearBreadcrumbs();
            this.setBreadcrumbs(this.dataSourceBreadcrumbItem, this.schemasBreadcrumbItem);
            this.view.clearContent();
            this.view.setContent(this.schemaExplorer);
        } else {
            this.onSchemaSelected(null);
        }
    }

    protected void onSchemaSelected(String schemaName) {
        this.view.clearContent();
        this.view.setContent(this.objectExplorer);
        this.objectExplorer.initialize(new DatabaseObjectExplorer.Settings().dataSourceUuid(this.settings.dataSourceUuid()).schemaName(schemaName));
        this.objectsBreadcrumbItem.setName(schemaName != null ? schemaName : this.translationService.getTranslation("DatabaseStructureExplorerViewImpl.defaultSchema"));
        this.clearBreadcrumbs();
        if (this.schemaExplorer.hasItems()) {
            this.setBreadcrumbs(this.dataSourceBreadcrumbItem, this.schemasBreadcrumbItem, this.objectsBreadcrumbItem);
        } else {
            this.setBreadcrumbs(this.dataSourceBreadcrumbItem, this.objectsBreadcrumbItem);
        }
    }

    protected void onDataBaseObjectSelected(String schemaName, String objectName) {
        this.view.clearContent();
        this.view.setContent(this.objectViewer);
        this.objectViewer.initialize(new TableObjectViewer.Settings().dataSourceUuid(this.settings.dataSourceUuid()).schemaName(schemaName).tableName(objectName));
        this.objectViewerBreadcrumbItem.setName(objectName);
        this.clearBreadcrumbs();
        if (this.schemaExplorer.hasItems()) {
            this.setBreadcrumbs(this.dataSourceBreadcrumbItem, this.schemasBreadcrumbItem, this.objectsBreadcrumbItem, this.objectViewerBreadcrumbItem);
        } else {
            this.setBreadcrumbs(this.dataSourceBreadcrumbItem, this.objectsBreadcrumbItem, this.objectViewerBreadcrumbItem);
        }
    }

    private void onDataSourceBreacrumbItemSelected() {
        if (this.handler != null) {
            this.handler.onDataSourceSelected();
        }
    }

    private void onShemasBreadcrumbItemSelected() {
        this.view.clearContent();
        this.view.setContent(this.schemaExplorer);
        this.clearBreadcrumbs();
        this.setBreadcrumbs(this.dataSourceBreadcrumbItem, this.schemasBreadcrumbItem);
    }

    private void onObjectsBreadcrumbItemSelected() {
        this.view.clearContent();
        this.view.setContent(this.objectExplorer);
        this.clearBreadcrumbs();
        if (this.schemaExplorer.hasItems()) {
            this.setBreadcrumbs(this.dataSourceBreadcrumbItem, this.schemasBreadcrumbItem, this.objectsBreadcrumbItem);
        } else {
            this.setBreadcrumbs(this.dataSourceBreadcrumbItem, this.objectsBreadcrumbItem);
        }
    }

    private void onObjectViewerBreadcrumbItemSelected() {
    }

    private void clearBreadcrumbs() {
        this.view.clearBreadcrumbs();
        this.dataSourceBreadcrumbItem.setActive(false);
        this.schemasBreadcrumbItem.setActive(false);
        this.objectsBreadcrumbItem.setActive(false);
        this.objectViewerBreadcrumbItem.setActive(false);
    }

    private void setBreadcrumbs(BreadcrumbItem ... items) {
        BreadcrumbItem lastItem = null;
        for (BreadcrumbItem item : items) {
            this.view.addBreadcrumbItem(item);
            lastItem = item;
        }
        if (lastItem != null && lastItem != this.dataSourceBreadcrumbItem) {
            lastItem.setActive(true);
        }
    }

    protected BreadcrumbItem createDataSourceBreadcrumbItem() {
        return this.createItem(this.buildDisplayableName("DatabaseStructureExplorerViewImpl.dataSourceTitle"), new Command(){

            public void execute() {
                DatabaseStructureExplorer.this.onDataSourceBreacrumbItemSelected();
            }
        });
    }

    protected BreadcrumbItem createSchemasBreadcrumbItem() {
        return this.createItem(this.translationService.getTranslation("DatabaseStructureExplorerViewImpl.schemasTitle"), new Command(){

            public void execute() {
                DatabaseStructureExplorer.this.onShemasBreadcrumbItemSelected();
            }
        });
    }

    protected BreadcrumbItem createObjectsBreadcrumbItem() {
        return this.createItem("", new Command(){

            public void execute() {
                DatabaseStructureExplorer.this.onObjectsBreadcrumbItemSelected();
            }
        });
    }

    protected BreadcrumbItem createObjectViewerBreadcrumbItem() {
        return this.createItem("", new Command(){

            public void execute() {
                DatabaseStructureExplorer.this.onObjectViewerBreadcrumbItemSelected();
            }
        });
    }

    private BreadcrumbItem createItem(String name, Command command) {
        BreadcrumbItem item = (BreadcrumbItem)this.itemInstance.get();
        item.setName(name);
        item.setCommand(command);
        return item;
    }

    private String buildDisplayableName(String dataSourceName) {
        return "<<" + dataSourceName;
    }

    public static class Settings {
        private String dataSourceName;
        private String dataSourceUuid;

        public String dataSourceName() {
            return this.dataSourceName;
        }

        public Settings dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public String dataSourceUuid() {
            return this.dataSourceUuid;
        }

        public Settings dataSourceUuid(String selectedDataSourceUuid) {
            this.dataSourceUuid = selectedDataSourceUuid;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Settings settings = (Settings)o;
            if (this.dataSourceName != null ? !this.dataSourceName.equals(settings.dataSourceName) : settings.dataSourceName != null) {
                return false;
            }
            return this.dataSourceUuid != null ? this.dataSourceUuid.equals(settings.dataSourceUuid) : settings.dataSourceUuid == null;
        }

        public int hashCode() {
            int result = this.dataSourceName != null ? this.dataSourceName.hashCode() : 0;
            result = ~(~result);
            result = 31 * result + (this.dataSourceUuid != null ? this.dataSourceUuid.hashCode() : 0);
            result = ~(~result);
            return result;
        }
    }
}

